/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.inventory.IContainerCallback;

public class InventoryInternal
implements Container,
Nameable {
    protected final ItemStack[] contents;
    private final String saveName;
    private final int stackLimit;
    private final BlockEntity invOwner;
    private final String displayNameKey;
    private final Component displayName;
    private final IContainerCallback callback;

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, String displayName) {
        this(invOwner, saveName, invSize, 0, displayName);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        this(invOwner, saveName, invSize, 0, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        this(invOwner, saveName, invSize, invStackLimit, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        this.contents = new ItemStack[invSize];
        this.invOwner = invOwner;
        this.saveName = saveName;
        this.stackLimit = invStackLimit;
        this.displayNameKey = displayName;
        this.displayName = Component.translatable((String)this.displayNameKey);
        this.callback = callback;
        this.clearContent();
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbtTag) {
        this.writeToNBT(provider, nbtTag, this.saveName);
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbtTag, String name) {
        ListTag listStacks = new ListTag();
        for (int index = 0; index < Math.min(this.contents.length, 256); index = (int)((short)(index + 1))) {
            if (this.contents[index].isEmpty()) continue;
            CompoundTag entry = (CompoundTag)this.contents[index].save(provider);
            entry.putByte("slot", (byte)index);
            listStacks.add((Object)entry);
        }
        nbtTag.put(name, (Tag)listStacks);
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTag) {
        this.readFromNBT(provider, nbtTag, this.saveName);
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTag, String name) {
        this.clearContent();
        ListTag listStacks = nbtTag.getList(name, 10);
        for (int index = 0; index < listStacks.size(); index = (int)((short)(index + 1))) {
            CompoundTag entry = listStacks.getCompound(index);
            int slot = (entry.contains("slot") ? entry.getByte("slot") : entry.getByte("Slot")) & 0xFF;
            if (!this.okSlotId(index)) continue;
            this.contents[slot] = ItemStack.parse((HolderLookup.Provider)provider, (Tag)entry).orElse(ItemStack.EMPTY);
        }
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    protected boolean okSlotId(int slotId) {
        return slotId > -1 && slotId < this.contents.length;
    }

    public String getNameKey() {
        return this.displayNameKey;
    }

    public int getContainerSize() {
        return this.contents.length;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slotId) {
        return this.okSlotId(slotId) ? this.contents[slotId] : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int slotId, int amount) {
        if (this.okSlotId(slotId) && !this.contents[slotId].isEmpty()) {
            if (this.contents[slotId].getCount() > amount) {
                ItemStack result = this.contents[slotId].split(amount);
                this.setChanged();
                return result;
            }
            ItemStack stack = this.contents[slotId];
            this.setItem(slotId, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slotId) {
        ItemStack returnStack = this.getItem(slotId);
        this.setItem(slotId, ItemStack.EMPTY);
        return returnStack;
    }

    public void setItem(int slotId, @NotNull ItemStack stack) {
        if (this.okSlotId(slotId)) {
            this.contents[slotId] = stack;
            if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    public int getMaxStackSize() {
        return this.stackLimit < 1 ? super.getMaxStackSize() : this.stackLimit;
    }

    public void setChanged() {
        if (this.invOwner != null) {
            this.invOwner.setChanged();
        }
        if (this.callback != null) {
            this.callback.onInventoryChange(this.invOwner, this);
        }
    }

    public boolean inReachOf(Player player) {
        return this.invOwner == null || player.distanceToSqr((double)this.invOwner.getBlockPos().getX() + 0.5, (double)this.invOwner.getBlockPos().getY() + 0.5, (double)this.invOwner.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public boolean blockUnchanged() {
        if (this.invOwner != null) {
            if (!this.invOwner.isRemoved()) {
                Level world = this.invOwner.getLevel();
                return world != null && world.getBlockEntity(this.invOwner.getBlockPos()) == this.invOwner;
            }
            return false;
        }
        return true;
    }

    public boolean stillValid(Player player) {
        boolean original;
        boolean bl = original = this.invOwner != null && this.blockUnchanged() && this.inReachOf(player);
        if (this.callback != null) {
            return this.callback.canInteractWith(this.invOwner, this, player, original);
        }
        return original;
    }

    public void startOpen(Player player) {
        if (this.callback != null) {
            this.callback.onContainerOpen(this.invOwner, this, player);
        }
    }

    public void stopOpen(Player player) {
        if (this.callback != null) {
            this.callback.onContainerClosed(this.invOwner, this, player);
        }
    }

    public boolean canPlaceItem(int slotId, @NotNull ItemStack stack) {
        return this.okSlotId(slotId);
    }

    public void clearContent() {
        for (int slot = 0; slot < this.contents.length; ++slot) {
            this.contents[slot] = ItemStack.EMPTY;
        }
    }

    public Component getName() {
        return this.displayName;
    }

    public boolean hasCustomName() {
        return false;
    }

    @Nullable
    public Component getCustomName() {
        return null;
    }
}

