/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.rgb16.IRGB16;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.core.self.Roster;

public class TileEntityRGB16
extends TileEntityBase
implements IRGB16_Tile {
    private final ImmutableRGB16 defaultRGB16;
    private RGB16 rgb16;

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, DyeColor.WHITE);
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, DyeColor color) {
        this(type, pos, state, new ImmutableRGB16(color.getName()));
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, IRGB16 rgb16) {
        super(type, pos, state);
        this.defaultRGB16 = rgb16.immutable();
        this.rgb16 = rgb16.mutable();
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, short rgbIndex) {
        this(type, pos, state, new ImmutableRGB16(rgbIndex));
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        short rgbIndex = this.getRGB16(null).getIndex();
        nbtTag.putShort("rgb16", rgbIndex);
        nbtTag.putByte("rgbsimple", RGB16Helper.getSimpleColor(rgbIndex));
    }

    @Override
    protected void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        this.loadRGB16(nbtTag.getShort("rgb16"));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)Roster.Components.RGB16_DATA.get(), (Object)this.rgb16.immutable());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.rgb16 = ((ImmutableRGB16)components.getOrDefault((DataComponentType)Roster.Components.RGB16_DATA.get(), (Object)this.defaultRGB16)).mutable();
    }

    private boolean loadRGB16(short rgbIndex) {
        return rgbIndex > -1 && rgbIndex < 4096 && this.getRGB16(null).setValues(rgbIndex);
    }

    @Override
    public RGB16 getRGB16(Player player) {
        if (this.rgb16 == null) {
            this.rgb16 = this.defaultRGB16.mutable();
        }
        return this.rgb16;
    }

    @Override
    public boolean setRGB16(short rgbIndex, Player player) {
        boolean result = this.loadRGB16(rgbIndex);
        if (result) {
            Helpers.syncTile(this);
        }
        return result;
    }

    public boolean setRGB16(IRGB16 rgb16, Player player) {
        return this.setRGB16(rgb16.getIndex(), player);
    }
}

