/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import java.nio.file.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import shetiphian.core.platform.IEnvironmentHelper;

public class NeoForgeEnvironment
implements IEnvironmentHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get().toAbsolutePath();
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public boolean isServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    @Override
    public boolean isClientThread() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT;
    }

    @Override
    public boolean isServerThread() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }
}

