/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import java.util.ServiceLoader;
import org.slf4j.Logger;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.SideExecutor;
import shetiphian.core.platform.IClientHelper;
import shetiphian.core.platform.ICommonHelper;
import shetiphian.core.platform.IEnvironmentHelper;
import shetiphian.core.platform.INetworkHelper;

public class Services {
    public static final IEnvironmentHelper PLATFORM = Services.load(IEnvironmentHelper.class);
    public static final INetworkHelper NETWORK = Services.load(INetworkHelper.class);
    public static final IClientHelper CLIENT = SideExecutor.isClient() ? Services.load(IClientHelper.class) : null;
    public static final ICommonHelper COMMON = Services.load(ICommonHelper.class);

    private static <T> T load(Class<T> clazz) {
        return Services.load(clazz, ShetiPhianCore.LOGGER);
    }

    public static <T> T load(Class<T> clazz, Logger logger) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        logger.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

