/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.SideExecutor;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.setup.ConfigObject;
import shetiphian.core.network.PacketPlayerConfig;
import shetiphian.core.platform.Services;

public final class Configs {
    public static final General GENERAL = new General();
    public static final CoreEdits CORE_EDITS = new CoreEdits();

    public static void sync() {
        if (Services.NETWORK.isClientReady()) {
            SideExecutor.runOnClient(() -> () -> Minecraft.getInstance().execute(() -> {
                try {
                    Services.NETWORK.sendToServer(PacketPlayerConfig.sync(ShetiPhianCore.CONFIGKEY_COLOR_BLEND_MODE, Configs.GENERAL.colorBlendMode.get().ordinal()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
    }

    static {
        PlayerConfigs.registerSyncProcessor((side, player) -> {
            if (side == PlayerConfigs.Side.CLIENT) {
                Configs.sync();
            }
        });
    }

    public static class General {
        ConfigObject<BlendMode> colorBlendMode = ConfigObject.of("color_blend_mode", BlendMode.RYB, "Adjust the default way RGB16 handles dyes\nRYB = blending is used to mix the colors\n > Like mixing paint, the dye will be added to the existing color\n > Sneak-Click to set to dye color\n\nRGB = Direct value manipulation\n > Click to increase, Sneak-Click to decrease\n\nRYB is easier to use but RGB is more precise");
        public ConfigObject<ToolModeControl> toolModeChange = ConfigObject.of("tool_mode_change", ToolModeControl.BOTH, "Tool Modes can be changed via Sneak+Scroll and/or Keybinding (default PageUp/Down)");
    }

    public static enum BlendMode {
        RGB,
        RYB;

    }

    public static class CoreEdits {
        public String ID = "core_edits";
        public String COMMENT = "Core Edits";
        public final ConfigObject<Boolean> enableThinBlockHandler = ConfigObject.of("thin_block_handler", Boolean.valueOf(true), "Modifies entity collision checks to work with thinner blocks\nUnmodified ignores blocks bellow 1/5 (slightly thicker than a lower trap door)\nModified processes blocks down to 3/32 (slightly thicker than carpets)\n\nIf you need to disable this to solve a compatibility issue, please report it to me\nNon-living entities and thinner blocks are already exempt to avoid compatibility issues");
        public final ConfigObject<Boolean> enableCarpetPassthrough = ConfigObject.of("carpet_passthrough", Boolean.valueOf(true), "When enabled carpets on top of scaffolding can be passed through just like snow").fallbackTo(false);
        public final ConfigObject<Boolean> bonemealRestoresBark = ConfigObject.of("bonemeal_restores_bark", Boolean.valueOf(true), "When enabled using bonemeal on a stripped log restores the bark");
        public final ConfigObject<Boolean> bonemealFlowerFix = ConfigObject.of("bonemeal_flower_fix", Boolean.valueOf(true), "When enabled using bonemeal on grass blocks also generates flowers from mods\nBy default Minecraft only picks flowers from its own FlowerFeature list, but when mods add flowers they get added to their own list");
    }

    public static class Synced {
        public static BlendMode getBlendMode(Player player) {
            int ordinal = PlayerConfigs.getPlayerConfig(player, ShetiPhianCore.CONFIGKEY_COLOR_BLEND_MODE, Configs.GENERAL.colorBlendMode.getDefault().ordinal(), () -> Configs.GENERAL.colorBlendMode.get().ordinal());
            BlendMode[] values = BlendMode.values();
            return ordinal >= 0 && ordinal < values.length ? values[ordinal] : Configs.GENERAL.colorBlendMode.getDefault();
        }
    }

    public static enum ToolModeControl {
        KEYBINDING,
        SNEAK_SCROLL,
        BOTH;


        public boolean isMouse() {
            return this != KEYBINDING;
        }

        public boolean isKeyboard() {
            return this != SNEAK_SCROLL;
        }
    }
}

