/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.self.Roster;

public class RecipeRGB16
extends CustomRecipe {
    public RecipeRGB16(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        int dyeCount = 0;
        ItemStack rgbStack = ItemStack.EMPTY;
        for (int index = 0; index < inv.size(); ++index) {
            ItemStack invStack = inv.getItem(index);
            if (this.isValid(invStack)) {
                if (invStack.getItem() instanceof IRGB16_Item) {
                    if (rgbStack.isEmpty()) {
                        rgbStack = invStack.copy();
                        continue;
                    }
                    return false;
                }
                ++dyeCount;
                continue;
            }
            if (invStack.isEmpty()) continue;
            return false;
        }
        if (!rgbStack.isEmpty() && dyeCount > 0) {
            return !RGB16StackHelper.isSame(this.assemble(inv, (HolderLookup.Provider)world.registryAccess()), rgbStack);
        }
        return false;
    }

    private boolean isValid(ItemStack stack) {
        IRGB16_Item item;
        Item item2;
        return !stack.isEmpty() && ((item2 = stack.getItem()) instanceof IRGB16_Item && (item = (IRGB16_Item)item2).enableDyeRecipe(stack) || DyeHelper.isDye(stack));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        Item invStack;
        ItemStack stack = ItemStack.EMPTY;
        ArrayList<Item> dye = new ArrayList<Item>();
        for (int index = 0; index < inv.size(); ++index) {
            invStack = inv.getItem(index);
            if (invStack.isEmpty() || !this.isValid((ItemStack)invStack)) continue;
            if (invStack.getItem() instanceof IRGB16_Item) {
                stack = invStack.copy();
                stack.setCount(1);
                continue;
            }
            dye.add(invStack);
        }
        invStack = stack.getItem();
        if (invStack instanceof IRGB16_Item) {
            IRGB16_Item item = (IRGB16_Item)invStack;
            RGB16 rgb16 = item.getRGB16(stack).mutable();
            short startingIndex = item.getStartingIndex(stack);
            if (rgb16 == null) {
                rgb16 = new RGB16(startingIndex);
            }
            boolean first = true;
            for (ItemStack itemStack : dye) {
                if (first && rgb16.getIndex() == startingIndex) {
                    rgb16.setValues(DyeHelper.getDyeName(itemStack));
                } else {
                    rgb16.add(DyeHelper.getDyeName(itemStack));
                }
                first = false;
            }
            item.setRGB16(stack, rgb16);
        }
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Roster.RecipeSerializers.RGB16_COLORIZE.get();
    }
}

