/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self;

import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.self.RecipeRGB16;
import shetiphian.core.self.Roster;
import shetiphian.core.self.teams.TeamCommand;

final class Registration {
    Registration(IEventBus modBus) {
        this.components(this.create(Registries.DATA_COMPONENT_TYPE, modBus));
        this.command(this.create(Registries.COMMAND_ARGUMENT_TYPE, modBus));
        this.entity(this.create((Registry)BuiltInRegistries.ENTITY_TYPE, modBus));
        this.recipe(this.create(BuiltInRegistries.RECIPE_TYPE, modBus));
        this.recipeSerializers(this.create(BuiltInRegistries.RECIPE_SERIALIZER, modBus));
    }

    private <T> DeferredRegister<T> create(Registry<T> registry, IEventBus eventBus) {
        return this.create(registry.key(), eventBus);
    }

    private <T> DeferredRegister<T> create(ResourceKey<? extends Registry<T>> key, IEventBus eventBus) {
        DeferredRegister registry = DeferredRegister.create(key, (String)"shetiphiancore");
        registry.register(eventBus);
        return registry;
    }

    private void components(DeferredRegister<DataComponentType<?>> reg) {
        Roster.Components.RGB16_DATA.wrap((id, builder) -> reg.register(id, () -> ((DataComponentType.Builder)builder).build()));
    }

    private void command(DeferredRegister<ArgumentTypeInfo<?, ?>> reg) {
        Roster.Command.TEAM.wrap(id -> reg.register(id, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(TeamCommand.TeamArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(TeamCommand.TeamArgument::new))));
    }

    private void entity(DeferredRegister<EntityType<?>> reg) {
        Roster.Entity.GUI_ITEM.wrap(id -> reg.register(id, () -> EntityType.Builder.of(EntityGuiItem::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(ShetiPhianCore.IDSTRING.apply((String)id))));
    }

    private void recipe(DeferredRegister<RecipeType<?>> reg) {
        Roster.Recipe.RGB16_COLORIZE.wrap(id -> reg.register(id, () -> RecipeType.simple((ResourceLocation)ShetiPhianCore.RESOURCE.apply((String)id))));
    }

    private void recipeSerializers(DeferredRegister<RecipeSerializer<?>> reg) {
        Roster.RecipeSerializers.RGB16_COLORIZE.wrap(id -> reg.register(id, () -> new SimpleCraftingRecipeSerializer(RecipeRGB16::new)));
    }
}

