/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ClientParticleHelper;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.client.UnclampedItemPropertyFunction;
import shetiphian.core.client.model.PackTextureOverrideHandler;
import shetiphian.core.common.Helpers;
import shetiphian.core.self.Roster;
import shetiphian.core.self.client.EventHandlerClient;
import shetiphian.core.self.client.GuiItemRenderer;
import shetiphian.core.self.client.model.ModelMultiLayered;

@Mod(value="shetiphiancore", dist={Dist.CLIENT})
public final class ModMainClient {
    public ModMainClient(ModContainer modContainer, IEventBus modEventBus) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::clientSetup);
        modEventBus.register((Object)new ModBusEvents());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ShetiPhianCore.CLIENT_PLAYER = () -> Minecraft.getInstance().player;
        ClientParticleHelper.init();
        PackTextureOverrideHandler.init();
        EntityRenderers.register(Roster.Entity.GUI_ITEM.get(), GuiItemRenderer::new);
        event.enqueueWork(() -> ClientHelpers.internal_registerProperties(set -> {
            ShetiPhianCore.LOGGER.debug("Registering ItemProperty [{}] on [{}]", set.getColumnKey(), set.getRowKey());
            ItemProperties.register((Item)((Item)set.getRowKey()), (ResourceLocation)ResourceLocation.parse((String)((String)set.getColumnKey())), (ItemPropertyFunction)UnclampedItemPropertyFunction.wrap((ItemPropertyFunction)set.getValue()));
        }));
        Helpers.REGISTRY_ACCESS = () -> {
            LocalPlayer player = Minecraft.getInstance().player;
            return player != null ? player.registryAccess() : null;
        };
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void registerBindings(RegisterKeyMappingsEvent event) {
            event.register(EventHandlerClient.KEY_TOOL_NEXT);
            event.register(EventHandlerClient.KEY_TOOL_PREVIOUS);
        }

        @SubscribeEvent
        public void modelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
            event.register(ResourceLocation.fromNamespaceAndPath((String)"shetiphian", (String)"layered"), (IGeometryLoader)ModelMultiLayered.LOADER);
        }

        @SubscribeEvent
        public void blockColorHandlerEvent(RegisterColorHandlersEvent.Block event) {
            ColorHandler.internal_registerBlocks(block -> {
                ShetiPhianCore.LOGGER.debug("Registering BlockColorProvider for [{}]", block);
                event.register((BlockColor)ColorHandler.BlockColor.INSTANCE, new Block[]{block});
            });
        }

        @SubscribeEvent
        public void itemColorHandlerEvent(RegisterColorHandlersEvent.Item event) {
            ColorHandler.internal_registerItems(item -> {
                ShetiPhianCore.LOGGER.debug("Registering ItemColorProvider for [{}]", item);
                event.register((ItemColor)ColorHandler.ItemColor.INSTANCE, new ItemLike[]{item});
            });
        }
    }

    private static class EventRelay
    extends EventHandlerClient {
        private EventRelay() {
        }

        @SubscribeEvent
        public void clientTick(ClientTickEvent.Post event) {
            this.onClientTick();
        }

        @SubscribeEvent
        public void mouseScrolling(InputEvent.MouseScrollingEvent event) {
            if (!event.isCanceled() && this.onMouseScroll(event.getScrollDeltaY())) {
                event.setCanceled(true);
            }
        }
    }
}

