/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class CustomRenderLayer
extends RenderType {
    private static final Function<Double, RenderType> LINES_WITH_DEPTH = Util.memoize(lineWidth -> CustomRenderLayer.make("scalable_lines", lineWidth, true));
    private static final Function<Double, RenderType> LINES_WITHOUT_DEPTH = Util.memoize(lineWidth -> CustomRenderLayer.make("scalable_depthless_lines", lineWidth, false));

    public CustomRenderLayer(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static RenderType make(String name, double lineWidth, boolean depthTest) {
        return RenderType.create((String)name, (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(lineWidth))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setDepthTestState(depthTest ? LEQUAL_DEPTH_TEST : NO_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
    }

    public static RenderType getLines(double width) {
        return LINES_WITH_DEPTH.apply(width);
    }

    public static RenderType getDepthlessLines(double width) {
        return LINES_WITHOUT_DEPTH.apply(width);
    }
}

