/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.network;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.inventory.AssignableWorldlyContainer;
import shetiphian.core.common.item.IToolMode;
import shetiphian.core.network.PacketPlayerConfig;
import shetiphian.core.platform.Services;
import shetiphian.core.self.network.PacketNameSyncPlayer;
import shetiphian.core.self.network.PacketNameSyncTeam;
import shetiphian.core.self.network.PacketSidedWrapper;
import shetiphian.core.self.network.PacketTool;

final class ServerPayloadHandler {
    static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    ServerPayloadHandler() {
    }

    void handle(PacketNameSyncPlayer packet, Player player) {
        String name;
        UUID uuid = packet.uuid();
        if (uuid != null && !(name = NameCache.getLastKnownUsername(uuid)).equals(NameCache.FALLBACK.apply((Object)uuid.toString()))) {
            Services.NETWORK.sendToPlayer((CustomPacketPayload)new PacketNameSyncPlayer(name, uuid), (ServerPlayer)player);
        }
    }

    void handle(PacketNameSyncTeam packet, Player player) {
        String name;
        String teamId = packet.teamId();
        if (!Strings.isNullOrEmpty((String)teamId) && !(name = NameCache.getLastKnownTeamName(teamId)).equals(NameCache.FALLBACK.apply((Object)teamId))) {
            Services.NETWORK.sendToPlayer((CustomPacketPayload)new PacketNameSyncTeam(name, teamId), (ServerPlayer)player);
        }
    }

    void handle(PacketPlayerConfig packet, Player player) {
        PlayerConfigs.setPlayerControlled(player, (ResourceLocation)packet.data().getLeft(), packet.data().getMiddle());
    }

    void handle(PacketSidedWrapper packet, Player player) {
        BlockEntity tile = player.level().getBlockEntity(packet.posTile());
        if (tile instanceof AssignableWorldlyContainer) {
            AssignableWorldlyContainer container = (AssignableWorldlyContainer)tile;
            for (Direction facing : Direction.values()) {
                container.setSideGroup(facing, packet.indexes()[facing.get3DDataValue()]);
            }
            container.onGroupsChanged();
            Helpers.syncTile(tile);
        }
    }

    void handle(PacketTool packet, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && stack.getItem() instanceof IToolMode) {
            ((IToolMode)stack.getItem()).changeMode(player, stack, packet.reverse());
        }
    }
}

