/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.teams;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import joptsimple.internal.Strings;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.NameCache;
import shetiphian.core.platform.Services;
import shetiphian.core.self.network.PacketTeamIdSync;
import shetiphian.core.self.teams.PlayerTeam;
import shetiphian.core.self.teams.TeamHelper;

public final class TeamCommand {
    private static final Component CREATE_TEAM_SUCCESS = Component.translatable((String)"shetiphiancore.team.create.success");
    private static final Component CREATE_TEAM_FAIL_IN_TEAM = Component.translatable((String)"shetiphiancore.team.create.fail.inteam");
    private static final Component CREATE_TEAM_FAIL_EXISTS = Component.translatable((String)"shetiphiancore.team.create.fail.exists");
    private static final String RENAME_SUCCESS = "shetiphiancore.team.rename.success";
    private static final Component RENAME_FAIL = Component.translatable((String)"shetiphiancore.team.rename.fail.same");
    private static final Component SEND_INVITE_SUCCESS = Component.translatable((String)"shetiphiancore.team.invite.send.success");
    private static final Component SEND_INVITE_FAIL_ALREADY_MEMBER = Component.translatable((String)"shetiphiancore.team.invite.send.fail.member");
    private static final String SEND_INVITE_FAIL_PENDING = "shetiphiancore.team.invite.send.fail.pending";
    private static final String INVITE_NOTICE = "shetiphiancore.team.invite.receive.notice";
    private static final String ACCEPT_INVITE_SUCCESS = "shetiphiancore.team.invite.accept.success";
    private static final String ACCEPT_INVITE_SUCCESS_NOTICE = "shetiphiancore.team.invite.accept.success.notice";
    private static final Component ACCEPT_INVITE_FAIL_PERMISSIONS = Component.translatable((String)"shetiphiancore.team.invite.accept.fail.permissions");
    private static final Component ACCEPT_INVITE_FAIL_MEMBER = Component.translatable((String)"shetiphiancore.team.invite.accept.fail.member");
    private static final Component ACCEPT_INVITE_FAIL_IN_TEAM = Component.translatable((String)"shetiphiancore.team.invite.accept.fail.inteam");
    private static final Component ACCEPT_INVITE_FAIL_NO_INVITE = Component.translatable((String)"shetiphiancore.team.invite.accept.fail.noinvite");
    private static final Component LEAVE_SUCCESS = Component.translatable((String)"shetiphiancore.team.leave.success");
    private static final String LEAVE_SUCCESS_NOTICE = "shetiphiancore.team.leave.success.notice";
    private static final Component LEAVE_FAILED_LEADER = Component.translatable((String)"shetiphiancore.team.leave.fail.leader");
    private static final Component KICK_SUCCESS = Component.translatable((String)"shetiphiancore.team.kick.success");
    private static final Component KICK_SUCCESS_NOTICE = Component.translatable((String)"shetiphiancore.team.kick.success.notice");
    private static final Component KICK_FAIL_RANK = Component.translatable((String)"shetiphiancore.team.kick.fail.rank");
    private static final Component KICK_FAIL_WRONG_TEAM = Component.translatable((String)"shetiphiancore.team.kick.fail.team");
    private static final Component PROMOTE_SUCCESS = Component.translatable((String)"shetiphiancore.team.rank.promote.success");
    private static final Component PROMOTED = Component.translatable((String)"shetiphiancore.team.rank.promote.success.notice");
    private static final Component PROMOTE_FAIL_ALREADY_MANAGER = Component.translatable((String)"shetiphiancore.team.rank.promote.fail.manager");
    private static final Component PROMOTE_FAIL_USER_NOT_IN_TEAM = Component.translatable((String)"shetiphiancore.team.rank.promote.fail.not_member");
    private static final Component DEMOTE_SUCCESS = Component.translatable((String)"shetiphiancore.team.rank.demote.success");
    private static final Component DEMOTED = Component.translatable((String)"shetiphiancore.team.rank.demote.success.notice");
    private static final Component DEMOTE_SELF_SUCCESS = Component.translatable((String)"shetiphiancore.team.rank.demote.success.self");
    private static final Component TRANSFER_SUCCESS = Component.translatable((String)"shetiphiancore.team.transfer.success");
    private static final String TRANSFER_SUCCESS_NOTICE = "shetiphiancore.team.transfer.success.notice";
    private static final Component TRANSFER_FAIL_SAME = Component.translatable((String)"shetiphiancore.team.transfer.fail.same");
    private static final String DISBAND_SUCCESS = "shetiphiancore.team.disband.success";
    private static final Component NO_TEAMS = Component.translatable((String)"shetiphiancore.team.no_teams");
    private static final Component TEAM_HAS_NO_MEMBERS = Component.translatable((String)"shetiphiancore.team.members.empty");
    private static final Component TEAM_DOESNT_EXIST = Component.translatable((String)"shetiphiancore.team.members.error.noteam");
    private static final Component YOUR_NOT_IN_A_TEAM = Component.translatable((String)"shetiphiancore.team.error.no_team");
    private static final Component YOUR_NOT_THE_TEAM_LEADER = Component.translatable((String)"shetiphiancore.team.error.not_leader");
    private static final Component YOUR_NOT_A_TEAM_MANAGER = Component.translatable((String)"shetiphiancore.team.error.not_manager.self");
    private static final Component PLAYER_NOT_A_TEAM_MANAGER = Component.translatable((String)"shetiphiancore.team.error.not_manager.other");
    private static final String SYSADMIN_CREATE_TEAM = "shetiphiancore.team.sysadmin.create.success";
    private static final String SYSADMIN_RENAME_SUCCESS = "shetiphiancore.team.sysadmin.rename.success";
    private static final String SYSADMIN_KICK_SUCCESS = "shetiphiancore.team.sysadmin.kick.success";
    private static final String SYSADMIN_KICKED_FROM_TEAM = "shetiphiancore.team.sysadmin.kick.inform";
    private static final String SYSADMIN_ADD_SUCCESS = "shetiphiancore.team.sysadmin.add.success";
    private static final String SYSADMIN_ADDED_TO_TEAM = "shetiphiancore.team.sysadmin.add.inform";
    private static final String SYSADMIN_TRANSFER_SUCCESS = "shetiphiancore.team.sysadmin.transfer.success";
    private static final String SYSADMIN_DISBAND_SUCCESS = "shetiphiancore.team.sysadmin.disband.success";
    private static final String SYSADMIN_TEAM_DISBANDED = "shetiphiancore.team.sysadmin.disband.inform";
    private static final Cache<ServerPlayer, Pair<PlayerTeam, Player>> INVITE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final String RANK_LEADER = "\u25c6 ";
    private static final String RANK_MANAGER = "\u25c7 ";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spc_teams").then(Commands.literal((String)"create").then(((RequiredArgumentBuilder)Commands.argument((String)"teamId", (ArgumentType)ResourceLocationArgument.id()).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"teamId"), (Component)Component.empty()))).then(Commands.argument((String)"displayName", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(context -> TeamCommand.createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"teamId"), ComponentArgument.getComponent((CommandContext)context, (String)"displayName"))))))).then(Commands.literal((String)"rename").then(Commands.argument((String)"displayName", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(context -> TeamCommand.rename((CommandSourceStack)context.getSource(), ComponentArgument.getComponent((CommandContext)context, (String)"displayName")))))).then(Commands.literal((String)"invite").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TeamCommand.invite((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"accept").executes(context -> TeamCommand.accept((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"leave").executes(context -> TeamCommand.leave((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"kick").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TeamCommand.kick((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"promote").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TeamCommand.promote((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"demote").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TeamCommand.demote((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TeamCommand.transfer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"disband").executes(context -> TeamCommand.disband((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"teams").executes(context -> TeamCommand.teams((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), null))).then(Commands.argument((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.info((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spc_teams_sysadmin").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"create").then(((RequiredArgumentBuilder)Commands.argument((String)"teamId", (ArgumentType)ResourceLocationArgument.id()).executes(context -> TeamCommand.sysadmin_createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"teamId"), (Component)Component.empty()))).then(Commands.argument((String)"displayName", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(context -> TeamCommand.sysadmin_createTeam((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"teamId"), ComponentArgument.getComponent((CommandContext)context, (String)"displayName"))))))).then(Commands.literal((String)"rename").then(Commands.argument((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.argument((String)"displayName", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(context -> TeamCommand.sysadmin_rename((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), ComponentArgument.getComponent((CommandContext)context, (String)"displayName"))))))).then(Commands.literal((String)"kick").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"inform", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_kick((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"inform"))))))).then(Commands.literal((String)"add").then(Commands.argument((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_add((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.getPlayers((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"teamId", (ArgumentType)new TeamArgument()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_transfer((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"), EntityArgument.getPlayer((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(Commands.literal((String)"disband").then(Commands.argument((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.sysadmin_disband((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext<CommandSourceStack>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"msg_team").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(context -> TeamCommand.teamMessage((CommandSourceStack)context.getSource(), MessageArgument.getMessage((CommandContext)context, (String)"message")))));
    }

    private static Pair<String, Component> processTeamIdentity(ResourceLocation id, Component displayName) {
        Object teamId = (String)(id.getNamespace().equals("minecraft") ? "" : id.getNamespace() + ":") + id.getPath();
        if (Strings.isNullOrEmpty((String)displayName.getString())) {
            displayName = Component.literal((String)teamId);
        }
        teamId = ((String)teamId).replaceAll(":", "-").replaceAll("/", ".");
        return Pair.of((Object)teamId, (Object)displayName);
    }

    private static int createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            Pair<String, Component> identity = TeamCommand.processTeamIdentity(teamId, displayName);
            if (!TeamHelper.doesTeamExist((String)identity.getLeft())) {
                if (TeamHelper.getTeam((Player)executor) == null) {
                    PlayerTeam.create((String)identity.getLeft(), (Player)executor, (Component)identity.getRight());
                    source.sendSuccess(() -> CREATE_TEAM_SUCCESS, false);
                } else {
                    source.sendFailure(CREATE_TEAM_FAIL_IN_TEAM);
                }
            } else {
                source.sendFailure(CREATE_TEAM_FAIL_EXISTS);
            }
        }
        return 0;
    }

    private static int rename(CommandSourceStack source, Component displayName) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.getUUID())) {
                    Component oldName = eTeam.getDisplayName();
                    if (eTeam.changeDisplayName(displayName)) {
                        MutableComponent message = Component.translatable((String)RENAME_SUCCESS, (Object[])new Object[]{oldName, eTeam.getDisplayName()});
                        source.sendSuccess(() -> message, false);
                    } else {
                        source.sendFailure(RENAME_FAIL);
                    }
                } else {
                    source.sendFailure(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int invite(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.getUUID())) {
                    Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
                    if (cachedInvite == null) {
                        if (!eTeam.equals(TeamHelper.getTeam(target.getUUID()))) {
                            MutableComponent invite = Component.translatable((String)INVITE_NOTICE, (Object[])new Object[]{eTeam.getDisplayName(), "'/spc_teams accept'", 15});
                            target.sendSystemMessage((Component)invite);
                            INVITE_CACHE.put((Object)target, (Object)Pair.of((Object)eTeam, (Object)executor));
                            source.sendSuccess(() -> SEND_INVITE_SUCCESS, false);
                        } else {
                            source.sendFailure(SEND_INVITE_FAIL_ALREADY_MEMBER);
                        }
                    } else {
                        MutableComponent invite = Component.translatable((String)SEND_INVITE_FAIL_PENDING, (Object[])new Object[]{((PlayerTeam)cachedInvite.getLeft()).getDisplayName()});
                        target.sendSystemMessage((Component)invite);
                    }
                } else {
                    source.sendFailure(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int accept(CommandSourceStack source) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
            if (cachedInvite != null) {
                PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
                if (eTeam == null) {
                    PlayerTeam team = (PlayerTeam)cachedInvite.getLeft();
                    if (team.isManager(((Player)cachedInvite.getRight()).getUUID())) {
                        TeamCommand.notifyTeam(source.getServer(), team.getMembers(), executor, true);
                        team.add((Player)executor);
                        MutableComponent invite = Component.translatable((String)ACCEPT_INVITE_SUCCESS, (Object[])new Object[]{team.getDisplayName()});
                        source.sendSuccess(() -> invite, false);
                    } else {
                        source.sendFailure(ACCEPT_INVITE_FAIL_PERMISSIONS);
                    }
                } else if (eTeam.equals(cachedInvite.getLeft())) {
                    source.sendFailure(ACCEPT_INVITE_FAIL_MEMBER);
                } else {
                    source.sendFailure(ACCEPT_INVITE_FAIL_IN_TEAM);
                }
            } else {
                source.sendFailure(ACCEPT_INVITE_FAIL_NO_INVITE);
            }
        }
        return 0;
    }

    private static int leave(CommandSourceStack source) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eId = executor.getUUID();
                if (!eId.equals(eTeam.getLeader())) {
                    eTeam.leave((Player)executor);
                    source.sendSuccess(() -> LEAVE_SUCCESS, false);
                    TeamCommand.notifyTeam(source.getServer(), eTeam.getMembers(), executor, false);
                } else {
                    source.sendFailure(LEAVE_FAILED_LEADER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static void notifyTeam(MinecraftServer server, List<UUID> members, ServerPlayer player, boolean joining) {
        MutableComponent message = Component.translatable((String)(joining ? ACCEPT_INVITE_SUCCESS_NOTICE : LEAVE_SUCCESS_NOTICE), (Object[])new Object[]{player.getDisplayName()});
        server.getPlayerList().getPlayers().forEach(serverPlayer -> {
            if (members.contains(serverPlayer.getUUID())) {
                serverPlayer.sendSystemMessage((Component)message);
            }
        });
    }

    private static int kick(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            if (executor.equals((Object)target)) {
                return TeamCommand.leave(source);
            }
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                UUID eID = executor.getUUID();
                if (eTeam.equals(TeamHelper.getTeam(target.getUUID()))) {
                    if (eID.equals(eTeam.getLeader()) || eTeam.isManager(eID) && !eTeam.isManager(target.getUUID())) {
                        eTeam.kick((Player)target);
                        target.sendSystemMessage(KICK_SUCCESS_NOTICE);
                        source.sendSuccess(() -> KICK_SUCCESS, false);
                    } else {
                        source.sendFailure(KICK_FAIL_RANK);
                    }
                } else {
                    source.sendFailure(KICK_FAIL_WRONG_TEAM);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int promote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.getUUID())) {
                    if (eTeam.getMembers().contains(target.getUUID())) {
                        if (eTeam.promote((Player)target)) {
                            target.sendSystemMessage(PROMOTED);
                            source.sendSuccess(() -> PROMOTE_SUCCESS, false);
                        } else {
                            source.sendFailure(PROMOTE_FAIL_ALREADY_MANAGER);
                        }
                    } else {
                        source.sendFailure(PROMOTE_FAIL_USER_NOT_IN_TEAM);
                    }
                } else {
                    source.sendFailure(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int demote(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.getUUID())) {
                    if (eTeam.demote((Player)target)) {
                        if (executor.equals((Object)target)) {
                            source.sendSuccess(() -> DEMOTE_SELF_SUCCESS, false);
                        } else {
                            target.sendSystemMessage(DEMOTED);
                            source.sendSuccess(() -> DEMOTE_SUCCESS, false);
                        }
                    } else {
                        source.sendFailure(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.sendFailure(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int transfer(CommandSourceStack source, ServerPlayer target) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.getUUID().equals(eTeam.getLeader())) {
                    if (eTeam.isManager(target.getUUID())) {
                        if (eTeam.transfer((Player)target)) {
                            MutableComponent message = Component.translatable((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{eTeam.getDisplayName()});
                            target.sendSystemMessage((Component)message);
                            source.sendSuccess(() -> TRANSFER_SUCCESS, false);
                        } else {
                            source.sendFailure(TRANSFER_FAIL_SAME);
                        }
                    } else {
                        source.sendFailure(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.sendFailure(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int disband(CommandSourceStack source) {
        Entity e = source.getEntity();
        if (e instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                if (executor.getUUID().equals(eTeam.getLeader())) {
                    MutableComponent message = Component.translatable((String)DISBAND_SUCCESS, (Object[])new Object[]{eTeam.getDisplayName()});
                    List<UUID> players = TeamHelper.deleteTeam(eTeam.getId());
                    source.getServer().getPlayerList().getPlayers().forEach(serverPlayer -> {
                        UUID uuid = serverPlayer.getUUID();
                        if (players.contains(uuid)) {
                            serverPlayer.sendSystemMessage((Component)message);
                        }
                    });
                } else {
                    source.sendFailure(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int teams(CommandSourceStack source) {
        Set<String> teams = TeamHelper.getTeams();
        if (!teams.isEmpty()) {
            MutableComponent message = Component.literal((String)"\u00a77\u00a7o<teamId> ['<displayName>']\u00a7r");
            teams.forEach(id -> message.append("\u00a75 :: \u00a7f").append(id).append("\u00a77 ['\u00a7f").append(TeamHelper.getTeamDisplayName(id)).append("\u00a77']"));
            message.append("\u00a7r");
            source.sendSuccess(() -> message, false);
            if (source.getServer().isPublished() && source.getPlayer() != null) {
                Services.NETWORK.sendToPlayer((CustomPacketPayload)PacketTeamIdSync.of(teams), source.getPlayer());
            }
        } else {
            source.sendFailure(NO_TEAMS);
        }
        return 0;
    }

    private static int info(CommandSourceStack source, String teamId) {
        Entity e;
        if (teamId == null && (e = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)e;
            PlayerTeam eTeam = TeamHelper.getTeam((Player)executor);
            if (eTeam != null) {
                teamId = eTeam.getId();
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
                return 0;
            }
        }
        if (TeamHelper.doesTeamExist(teamId)) {
            PlayerTeam eTeam = TeamHelper.getTeam(teamId);
            if (eTeam != null) {
                MutableComponent message = Component.literal((String)"\u00a7f").append(teamId).append("\u00a77 ['\u00a7f").append(eTeam.getDisplayName()).append("\u00a77']");
                List<UUID> members = eTeam.getMembers();
                if (!members.isEmpty()) {
                    UUID leader = eTeam.getLeader();
                    if (leader != null) {
                        message.append("\n");
                        message.append(RANK_LEADER + NameCache.getLastKnownUsername(leader));
                    }
                    StringBuilder bldManagers = new StringBuilder();
                    eTeam.getManagers().forEach(manager -> {
                        if (!manager.equals(leader)) {
                            bldManagers.append(NameCache.getLastKnownUsername(manager)).append(", ");
                        }
                    });
                    if (bldManagers.length() > 0) {
                        String names = bldManagers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.append("\n");
                        message.append(RANK_MANAGER + names);
                    }
                    StringBuilder bldMembers = new StringBuilder();
                    members.forEach(member -> {
                        if (!eTeam.isManager((UUID)member)) {
                            bldMembers.append(NameCache.getLastKnownUsername(member)).append(", ");
                        }
                    });
                    if (bldMembers.length() > 0) {
                        String names = bldMembers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.append("\n");
                        message.append(names);
                    }
                } else {
                    message.append(TEAM_HAS_NO_MEMBERS);
                }
                source.sendSuccess(() -> message, false);
            }
        } else {
            source.sendFailure(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_createTeam(CommandSourceStack source, ResourceLocation teamId, Component displayName) {
        Pair<String, Component> identity = TeamCommand.processTeamIdentity(teamId, displayName);
        if (!TeamHelper.doesTeamExist((String)identity.getLeft())) {
            PlayerTeam team = PlayerTeam.create((String)identity.getLeft(), null, (Component)identity.getRight());
            source.sendSuccess(() -> Component.translatable((String)SYSADMIN_CREATE_TEAM, (Object[])new Object[]{team.getId(), team.getDisplayName()}), true);
        } else {
            source.sendFailure(CREATE_TEAM_FAIL_EXISTS);
        }
        return 0;
    }

    private static int sysadmin_rename(CommandSourceStack source, String teamId, Component displayName) {
        PlayerTeam eTeam = TeamHelper.TEAMS.get(teamId);
        if (eTeam != null) {
            Component oldName = eTeam.getDisplayName();
            if (eTeam.changeDisplayName(displayName)) {
                source.sendSuccess(() -> Component.translatable((String)SYSADMIN_RENAME_SUCCESS, (Object[])new Object[]{teamId, oldName, eTeam.getDisplayName()}), true);
            } else {
                source.sendFailure(RENAME_FAIL);
            }
        } else {
            source.sendFailure(YOUR_NOT_IN_A_TEAM);
        }
        return 0;
    }

    private static int sysadmin_kick(CommandSourceStack source, Collection<ServerPlayer> players, boolean inform) {
        AtomicInteger counter = new AtomicInteger();
        MutableComponent names = Component.literal((String)" [");
        players.forEach(player -> {
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null) {
                current.kick((Player)player);
                if (inform) {
                    MutableComponent message = Component.translatable((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.sendSystemMessage((Component)message);
                }
                TeamCommand.notifyTeam(source.getServer(), current.getMembers(), player, false);
                if (counter.get() > 0) {
                    names.append(", ");
                }
                counter.getAndIncrement();
                names.append(player.getDisplayName());
            }
        });
        if (counter.get() > 0) {
            names.append("]");
            source.sendSuccess(() -> Component.translatable((String)SYSADMIN_KICK_SUCCESS, (Object[])new Object[]{counter.get()}).append((Component)names), true);
        }
        return 0;
    }

    private static int sysadmin_add(CommandSourceStack source, String teamId, Collection<ServerPlayer> players, boolean force) {
        PlayerTeam team = TeamHelper.TEAMS.get(teamId);
        if (team != null) {
            AtomicInteger counter = new AtomicInteger();
            MutableComponent names = Component.literal((String)" [");
            players.forEach(player -> {
                MutableComponent message;
                PlayerTeam current = TeamHelper.getTeam((Player)player);
                if (current != null && force) {
                    current.kick((Player)player);
                    message = Component.translatable((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.sendSystemMessage((Component)message);
                    TeamCommand.notifyTeam(source.getServer(), team.getMembers(), player, false);
                    current = null;
                }
                if (current == null) {
                    TeamCommand.notifyTeam(source.getServer(), team.getMembers(), player, true);
                    team.add((Player)player);
                    message = Component.translatable((String)SYSADMIN_ADDED_TO_TEAM, (Object[])new Object[]{team.getDisplayName()});
                    player.sendSystemMessage((Component)message);
                    if (counter.get() > 0) {
                        names.append(", ");
                    }
                    counter.getAndIncrement();
                    names.append(player.getDisplayName());
                }
            });
            if (counter.get() > 0) {
                names.append("]");
                source.sendSuccess(() -> Component.translatable((String)SYSADMIN_ADD_SUCCESS, (Object[])new Object[]{counter.get(), teamId}).append((Component)names), true);
            }
        } else {
            source.sendFailure(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_transfer(CommandSourceStack source, String teamId, ServerPlayer player, boolean force) {
        PlayerTeam team = TeamHelper.TEAMS.get(teamId);
        if (team != null) {
            MutableComponent message;
            PlayerTeam current = TeamHelper.getTeam((Player)player);
            if (current != null && force) {
                current.kick((Player)player);
                message = Component.translatable((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                player.sendSystemMessage((Component)message);
                current = null;
            }
            if (current == null) {
                if (team.transfer((Player)player)) {
                    message = Component.translatable((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{team.getDisplayName()});
                    player.sendSystemMessage((Component)message);
                    source.sendSuccess(() -> Component.translatable((String)SYSADMIN_TRANSFER_SUCCESS, (Object[])new Object[]{teamId, player.getDisplayName()}), true);
                } else {
                    source.sendFailure(TRANSFER_FAIL_SAME);
                }
            }
        } else {
            source.sendFailure(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_disband(CommandSourceStack source, String teamId) {
        if (TeamHelper.doesTeamExist(teamId)) {
            MutableComponent message = Component.translatable((String)SYSADMIN_TEAM_DISBANDED, (Object[])new Object[]{TeamHelper.getTeamDisplayName(teamId)});
            List<UUID> players = TeamHelper.deleteTeam(teamId);
            source.getServer().getPlayerList().getPlayers().forEach(serverPlayer -> {
                UUID uuid = serverPlayer.getUUID();
                if (players.contains(uuid)) {
                    serverPlayer.sendSystemMessage((Component)message);
                }
            });
            source.sendSuccess(() -> Component.translatable((String)SYSADMIN_DISBAND_SUCCESS, (Object[])new Object[]{teamId}), true);
        } else {
            source.sendFailure(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int teamMessage(CommandSourceStack source, Component message) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerTeam team = TeamHelper.getTeam((Player)player);
            if (team != null) {
                String rank = player.getUUID().equals(team.getLeader()) ? RANK_LEADER : (team.isManager(player.getUUID()) ? RANK_MANAGER : "");
                MutableComponent textComponent = Component.literal((String)("\u00a7a[team]\u00a7r " + rank)).append(player.getDisplayName()).append("\u00a7a:\u00a7r ").append(message);
                List<UUID> members = team.getMembers();
                source.getServer().getPlayerList().getPlayers().forEach(arg_0 -> TeamCommand.lambda$teamMessage$49(members, (Component)textComponent, arg_0));
            } else {
                source.sendFailure(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static /* synthetic */ void lambda$teamMessage$49(List members, Component textComponent, ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.getUUID();
        if (members.contains(uuid)) {
            serverPlayer.sendSystemMessage(textComponent);
        }
    }

    public static class TeamArgument
    implements ArgumentType<String> {
        public static String get(CommandContext<CommandSourceStack> context, String key) {
            return (String)context.getArgument(key, String.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.suggest(TeamHelper.getTeams(), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }
}

