/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WiseOakBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<WiseOakBlock> CODEC = WiseOakBlock.simpleCodec(WiseOakBlock::new);
    public static final EnumProperty<State> STATE = EnumProperty.create((String)"state", State.class);
    private static final List<BlockPos> KNOWLEDGE_PARTICLE_POS = BlockPos.betweenClosedStream((int)-2, (int)-2, (int)-2, (int)2, (int)1, (int)2).filter(blockPos -> Math.abs(blockPos.getX()) == 2 || Math.abs(blockPos.getZ()) == 2).map(BlockPos::immutable).toList();
    private static final List<BlockPos> DESTROY_PARTICLE_POS = BlockPos.betweenClosedStream((int)-3, (int)-3, (int)-2, (int)3, (int)2, (int)3).filter(blockPos -> {
        double l = Vec3.atCenterOf((Vec3i)blockPos).length();
        return l > 2.5 && l < 3.5;
    }).map(BlockPos::immutable).toList();

    public WiseOakBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)State.NONE)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STATE, FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WiseOakTile(pos, state);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        State s = (State)((Object)state.getValue(STATE));
        if (s.isBlinking()) {
            level.setBlock(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)State.getNonBlinking(s))), 3);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)blockEntity;
            return tile.onInteract(state, level, pos, player, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)blockEntity;
            tile.onAttack(state, level, pos, player);
        }
        super.attack(state, level, pos, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return WiseOakBlock.getTicker(pBlockEntityType, MysticalOakTree.TILE.get(), WiseOakTile::tick);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel level, T blockEntity) {
        return super.getListener(level, blockEntity);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.isClientSide) {
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (IntProvider)UniformInt.of((int)1, (int)1), (Direction)d, () -> Vec3.ZERO, (double)0.55);
                }
            }
            return true;
        }
        return super.triggerEvent(state, level, pos, id, param);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (state.getValue(STATE) == State.SLEEPING && random.nextInt(14) == 0) {
            BlockPos targetPos = KNOWLEDGE_PARTICLE_POS.get(level.random.nextInt(KNOWLEDGE_PARTICLE_POS.size()));
            WiseOakBlock.spawnEnchantParticle(level, pos.above(), random, targetPos);
        }
    }

    private static void spawnEnchantParticle(Level level, BlockPos pos, RandomSource random, BlockPos targetPos) {
        level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)((float)targetPos.getX() + random.nextFloat()) - 0.5, (double)((float)targetPos.getY() + random.nextFloat()) - 0.5, (double)((float)targetPos.getZ() + random.nextFloat()) - 0.5);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        super.spawnDestroyParticles(level, player, pos, state);
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        if (!EnchantmentHelper.hasTag((ItemStack)heldItem, (TagKey)EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            for (int i = 0; i < 30; ++i) {
                BlockPos targetPos = DESTROY_PARTICLE_POS.get(level.random.nextInt(DESTROY_PARTICLE_POS.size()));
                WiseOakBlock.spawnEnchantParticle(level, pos.offset((Vec3i)targetPos), level.random, targetPos.multiply(-1));
            }
        }
    }

    public static enum State implements StringRepresentable
    {
        NONE("none"),
        BLINKING("blinking"),
        SLEEPING("sleeping"),
        ANGRY("angry"),
        ANGRY_BLINKING("angry_blinking"),
        BLOWING("blowing"),
        THICC("thicc");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean canBlink() {
            return this == NONE || this == ANGRY;
        }

        public boolean isBlinking() {
            return this == BLINKING || this == ANGRY_BLINKING;
        }

        public static State getBlinking(State s) {
            if (s == ANGRY || s == BLOWING || s == THICC) {
                return ANGRY_BLINKING;
            }
            return BLINKING;
        }

        public static State getNonBlinking(State s) {
            if (s == ANGRY_BLINKING) {
                return ANGRY;
            }
            return NONE;
        }

        public boolean canSleep() {
            return this == NONE || this == BLINKING;
        }

        public boolean isAngry() {
            return this == ANGRY || this == ANGRY_BLINKING;
        }

        public boolean isBlowing() {
            return this == BLOWING || this == THICC;
        }
    }
}

