/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.common.menu.WalletMenu;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Learth/terrarium/tempad/common/items/WalletInventory;", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "Lnet/minecraft/world/MenuProvider;", "stack", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/world/item/ItemStack;)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "isFull", "", "()Z", "hasAnyItems", "getHasAnyItems", "insertItem", "simulate", "onContentsChanged", "", "slot", "", "isItemValid", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "tempad-1.21.1"})
public final class WalletInventory
extends ItemStackHandler
implements MenuProvider {
    @NotNull
    private final ItemStack stack;

    public WalletInventory(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super(18);
        this.stack = stack;
        ModComponentsKt.getWalletContents((MutableDataComponentHolder)this.stack).copyInto(this.stacks);
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final boolean isFull() {
        Iterator iterator = this.stacks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack item = (ItemStack)iterator2.next();
            if (!item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final boolean getHasAnyItems() {
        Iterator iterator = this.stacks.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack item = (ItemStack)iterator2.next();
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack remaining = stack;
        for (int i2 = 0; i2 < 18; ++i2) {
            if (!(remaining = this.insertItem(i2, remaining, simulate)).isEmpty()) continue;
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        return remaining;
    }

    protected void onContentsChanged(int slot) {
        ModComponentsKt.setWalletContents((MutableDataComponentHolder)this.stack, ItemContainerContents.fromItems((List)((List)this.stacks)));
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack) != null && stack.getItem() == ModItems.INSTANCE.getLocationCard();
    }

    @NotNull
    public Component getDisplayName() {
        Component component = this.stack.getHoverName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getHoverName(...)");
        return component;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new WalletMenu(containerId, playerInventory, this);
    }
}

