/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void giveItem(Player player, ItemStack stack) {
        ItemStack copy = stack.copy();
        if (!player.getInventory().add(copy)) {
            ItemEntity entityItem = new ItemEntity(player.level(), player.getX(), player.getY(0.5), player.getZ(), copy);
            entityItem.setNoPickUpDelay();
            entityItem.setThrower((Entity)player);
            player.level().addFreshEntity((Entity)entityItem);
        }
    }

    public static void removeItem(Player player, ItemStack stack) {
        ImmutableList inventories = ImmutableList.of((Object)player.getInventory().items, (Object)player.getInventory().offhand, (Object)player.getInventory().armor);
        for (NonNullList inv : inventories) {
            for (int i = 0; i < inv.size(); ++i) {
                if (stack != inv.get(i)) continue;
                inv.set(i, (Object)ItemStack.EMPTY);
                return;
            }
        }
    }

    public static CompoundTag getPersistedDataSubcompound(Player player, String subCompoundKey) {
        CompoundTag persistedData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.contains("PlayerPersisted")) {
            forgeData.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistedData = forgeData.getCompound("PlayerPersisted")).contains(subCompoundKey)) {
            persistedData.put(subCompoundKey, (Tag)new CompoundTag());
        }
        return persistedData.getCompound(subCompoundKey);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, Predicate<ItemStack> predicate) {
        return PlayerUtils.getNonEmptyStacks(player, true, true, true, predicate);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor) {
        return PlayerUtils.getNonEmptyStacks(player, includeMain, includeOffHand, includeArmor, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        NonNullList list = NonNullList.create();
        if (includeMain) {
            for (ItemStack stack : player.getInventory().items) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeOffHand) {
            for (ItemStack stack : player.getInventory().offhand) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.getInventory().armor) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack getFirstValidStack(Player player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        if (includeOffHand) {
            for (ItemStack stack : player.getInventory().offhand) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.getInventory().armor) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeMain) {
            for (ItemStack stack : player.getInventory().items) {
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }
}

