/*
 * Decompiled with CFR 0.152.
 */
package trofers.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.entity.TrophyBlockEntity;
import trofers.registry.ModBlockEntityTypes;
import trofers.screen.TrophySelectionScreen;
import trofers.trophy.Trophy;

public class TrophyBlock
extends BaseEntityBlock {
    public static final String DESCRIPTION_ID = Util.makeDescriptionId((String)"block", (ResourceLocation)Trofers.id("trophy"));
    private final int height;
    private final VoxelShape shape;
    private final MapCodec<TrophyBlock> codec;

    private TrophyBlock(BlockBehaviour.Properties properties, int height, VoxelShape shape) {
        super(properties);
        this.height = height;
        this.shape = shape;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.codec = TrophyBlock.simpleCodec(p -> new TrophyBlock((BlockBehaviour.Properties)p, height, shape));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    public static TrophyBlock createPillarTrophy(BlockBehaviour.Properties properties, int size) {
        return new TrophyBlock(properties, size, TrophyBlock.createPillarShape(size));
    }

    public static TrophyBlock createPlateTrophy(BlockBehaviour.Properties properties, int size) {
        return new TrophyBlock(properties, 2, TrophyBlock.createPlateShape(size));
    }

    private static VoxelShape createPillarShape(int size) {
        int width = 2 * (size - 2);
        return Shapes.or((VoxelShape)TrophyBlock.centeredBox(width, 0, 2), (VoxelShape[])new VoxelShape[]{TrophyBlock.centeredBox(width - 2, 2, size - 2), TrophyBlock.centeredBox(width, size - 2, size)});
    }

    private static VoxelShape createPlateShape(int size) {
        int width = 2 * (size - 2);
        return TrophyBlock.box((double)(8.0 - (double)width / 2.0), (double)0.0, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)2.0, (double)(8.0 + (double)width / 2.0));
    }

    private static VoxelShape centeredBox(int width, int minY, int maxY) {
        return TrophyBlock.box((double)(8.0 - (double)width / 2.0), (double)minY, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)maxY, (double)(8.0 + (double)width / 2.0));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDescriptionId() {
        return DESCRIPTION_ID;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null) {
            tooltip.addAll(trophy.tooltip());
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
            if (placer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)placer;
                blockEntity2.resetRewardCooldown(player);
            }
        }
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isWaterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.TROPHY.get()).create(pos, state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
            return blockEntity2.getItem();
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        TrophyBlockEntity blockEntity;
        if (player.isCreative()) {
            if (level.isClientSide()) {
                TrophySelectionScreen.open(state, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)blockEntity2).applyEffect(player)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : TrophyBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntity.TICKER);
    }
}

