/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import trofers.data.ConditionalTrophyDrops;
import trofers.registry.ModRegistries;

public class AdvancementDrops
extends ConditionalTrophyDrops {
    public static final MapCodec<AdvancementDrops> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> AdvancementDrops.codecStart(instance).and((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)ResourceLocation.CODEC).stable().fieldOf("trophies").forGetter(m -> m.trophies)).apply((Applicative)instance, AdvancementDrops::new));
    public static final Codec<AdvancementDrops> CODEC = MAP_CODEC.codec();
    public static final AdvancementDrops NONE = new AdvancementDrops(List.of(), (ItemLike)Items.AIR, new HashMap<ResourceLocation, ResourceLocation>());
    private final Map<ResourceLocation, ResourceLocation> trophies;

    public AdvancementDrops(List<LootItemCondition> conditions, ItemLike trophyBase, Map<ResourceLocation, ResourceLocation> trophies) {
        super(conditions, trophyBase.asItem());
        this.trophies = trophies;
    }

    public static void onAdvancementAwarded(Player player, AdvancementHolder advancement) {
        if (!player.level().isClientSide()) {
            ModRegistries.advancementDrops().ifPresent(advancementDrops -> {
                LootParams lootParams = new LootParams.Builder((ServerLevel)player.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.ADVANCEMENT_REWARD);
                LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
                advancementDrops.stream().forEach(entry -> entry.onAdvancementEarned(player, advancement, lootContext));
            });
        }
    }

    private void onAdvancementEarned(Player player, AdvancementHolder advancement, LootContext lootContext) {
        if (this.matchesConditions(lootContext)) {
            ResourceLocation trophyId = this.trophies.get(advancement.id());
            this.awardTrophy(trophyId, stack -> this.giveItemToPlayer(player, (ItemStack)stack));
        }
    }

    private void giveItemToPlayer(Player player, ItemStack stack) {
        if (player.addItem(stack)) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.containerMenu.broadcastChanges();
        } else {
            ItemEntity itemEntity = player.drop(stack, false);
            if (itemEntity != null) {
                itemEntity.setNoPickUpDelay();
                itemEntity.setTarget(player.getUUID());
            }
        }
    }
}

