/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import trofers.neoforge.datagen.providers.trophies.AdAstraTrophies;
import trofers.neoforge.datagen.providers.trophies.AlexsMobsTrophies;
import trofers.neoforge.datagen.providers.trophies.EntityTrophyProvider;
import trofers.neoforge.datagen.providers.trophies.QuarkTrophies;
import trofers.neoforge.datagen.providers.trophies.ThermalTrophies;
import trofers.neoforge.datagen.providers.trophies.TinkersConstructTrophies;
import trofers.neoforge.datagen.providers.trophies.TrophyProvider;
import trofers.neoforge.datagen.providers.trophies.VanillaTrophies;
import trofers.registry.ModRegistries;
import trofers.trophy.builder.TrophyBuilder;

public class TrophyProviders
implements DataProvider {
    private final PackOutput packOutput;
    public final List<EntityTrophyProvider> entityTrophies = List.of(new VanillaTrophies(), new AlexsMobsTrophies(), new QuarkTrophies(), new ThermalTrophies(), new TinkersConstructTrophies(), new AdAstraTrophies());

    public TrophyProviders(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected List<TrophyProvider> getTrophyProviders() {
        return new ArrayList<TrophyProvider>(this.entityTrophies);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        List<TrophyProvider> trophyProviders = this.getTrophyProviders();
        for (TrophyProvider trophyProvider : trophyProviders) {
            trophyProvider.addTrophies();
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Path outputFolder = this.packOutput.getOutputFolder();
        HashSet resourceLocations = Sets.newHashSet();
        for (TrophyProvider trophyProvider : trophyProviders) {
            Map<ResourceLocation, TrophyBuilder<?>> trophies = trophyProvider.getTrophies();
            for (ResourceLocation trophyId : trophies.keySet()) {
                if (!resourceLocations.add(trophyId)) {
                    throw new IllegalStateException("Duplicate trophy " + String.valueOf(trophyId));
                }
                Path path = TrophyProviders.createPath(outputFolder, trophyId);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)trophies.get(trophyId).toJson(), (Path)path));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static Path createPath(Path path, ResourceLocation trophyId) {
        return path.resolve("data/" + trophyId.getNamespace() + "/" + ModRegistries.TROPHIES.location().toString().replace(':', '/') + "/" + trophyId.getPath() + ".json");
    }

    public String getName() {
        return "Trophies";
    }
}

