/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.camping.Camping;
import net.satisfy.camping.core.util.BackpackVariant;
import net.satisfy.camping.core.util.EnderpackVariant;
import net.satisfy.camping.core.world.block.BackpackBlock;
import net.satisfy.camping.core.world.block.EnderpackBlock;
import net.satisfy.camping.core.world.block.GrillBlock;
import net.satisfy.camping.core.world.block.SleepingBagBlock;
import net.satisfy.camping.core.world.block.TentMainBlock;
import net.satisfy.camping.core.world.block.TentMainHeadBlock;
import net.satisfy.camping.core.world.block.TentRightBlock;
import net.satisfy.camping.core.world.block.TentRightHeadBlock;

public class CampingBlocks {
    public static final BlockBehaviour.Properties BACKPACK_BEHAVIOUR = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BIT).strength(1.5f).sound(SoundType.CANDLE).ignitedByLava().noOcclusion().noTerrainParticles().instabreak();
    public static final Block GRILL = new GrillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).lightLevel(state -> (Boolean)state.getValue((Property)GrillBlock.LIT) != false ? 10 : 0));
    public static final Block ENDERPACK = new EnderpackBlock(BACKPACK_BEHAVIOUR, EnderpackVariant.ENDERPACK);
    public static final Block ENDERBAG = new EnderpackBlock(BACKPACK_BEHAVIOUR, EnderpackVariant.ENDERBAG);
    public static final Block GOODYBAG = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.GOODYBAG);
    public static final Block LARGE_BACKPACK = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.LARGE_BACKPACK);
    public static final Block SHEEPBAG = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.SHEEPBAG);
    public static final Block SMALL_BACKPACK = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.SMALL_BACKPACK);
    public static final Block WANDERER_BACKPACK = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.WANDERER_BACKPACK);
    public static final Block WANDERER_BAG = new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackVariant.WANDERER_BAG);
    public static final Map<String, Block> SLEEPING_BAGS = new HashMap<String, Block>();
    public static final Map<String, Block> TENT_MAIN = new HashMap<String, Block>();
    public static final Map<String, Block> TENT_MAIN_HEAD = new HashMap<String, Block>();
    public static final Map<String, Block> TENT_RIGHT = new HashMap<String, Block>();
    public static final Map<String, Block> TENT_HEAD_RIGHT = new HashMap<String, Block>();

    public static void register(BiConsumer<Block, ResourceLocation> consumer) {
        consumer.accept(GRILL, Camping.identifier("grill"));
        consumer.accept(ENDERPACK, Camping.identifier("enderpack"));
        consumer.accept(ENDERBAG, Camping.identifier("enderbag"));
        consumer.accept(GOODYBAG, Camping.identifier("goodybag"));
        consumer.accept(LARGE_BACKPACK, Camping.identifier("large_backpack"));
        consumer.accept(SHEEPBAG, Camping.identifier("sheepbag"));
        consumer.accept(SMALL_BACKPACK, Camping.identifier("small_backpack"));
        consumer.accept(WANDERER_BACKPACK, Camping.identifier("wanderer_backpack"));
        consumer.accept(WANDERER_BAG, Camping.identifier("wanderer_bag"));
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.getName();
            SleepingBagBlock dyedSleepingBag = new SleepingBagBlock(dyeColor);
            SLEEPING_BAGS.put(colorName, (Block)dyedSleepingBag);
            consumer.accept((Block)dyedSleepingBag, Camping.identifier("sleeping_bag_" + colorName));
            TentMainBlock coloredTentMain = new TentMainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak(), dyeColor);
            TentMainHeadBlock coloredTentMainHead = new TentMainHeadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak(), dyeColor);
            TentRightBlock coloredTentRight = new TentRightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak(), dyeColor);
            TentRightHeadBlock coloredTentHeadRight = new TentRightHeadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak(), dyeColor);
            TENT_MAIN.put(colorName, (Block)coloredTentMain);
            TENT_MAIN_HEAD.put(colorName, (Block)coloredTentMainHead);
            TENT_RIGHT.put(colorName, (Block)coloredTentRight);
            TENT_HEAD_RIGHT.put(colorName, (Block)coloredTentHeadRight);
            consumer.accept((Block)coloredTentMain, Camping.identifier("tent_" + colorName));
            consumer.accept((Block)coloredTentMainHead, Camping.identifier("tent_head_" + colorName));
            consumer.accept((Block)coloredTentRight, Camping.identifier("tent_right_" + colorName));
            consumer.accept((Block)coloredTentHeadRight, Camping.identifier("tent_head_right_" + colorName));
        }
    }
}

