/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.Item;
import net.satisfy.camping.client.model.BackpackModel;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.core.registry.CampingItems;

public class BackpackRegistry {
    private static final Map<Item, BackpackModel> models = new HashMap<Item, BackpackModel>();

    public static Model getBodyModel(Item item, ModelPart baseBody) {
        BackpackModel model = models.computeIfAbsent(item, key -> {
            if (key == CampingItems.SMALL_BACKPACK) {
                return new SmallBackpackModel(SmallBackpackModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.LARGE_BACKPACK) {
                return new LargeBackpackModel(LargeBackpackModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.WANDERER_BACKPACK) {
                return new WandererBackpackModel(WandererBackpackModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.WANDERER_BAG) {
                return new WandererBagModel(WandererBagModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.GOODYBAG) {
                return new GoodybagModel(GoodybagModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.SHEEPBAG) {
                return new SheepbagModel(SheepbagModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.ENDERPACK) {
                return new EnderpackModel(EnderpackModel.createBodyLayer().bakeRoot());
            }
            if (key == CampingItems.ENDERBAG) {
                return new EnderbagModel(EnderbagModel.createBodyLayer().bakeRoot());
            }
            return null;
        });
        assert (model != null);
        model.copyBody(baseBody);
        return (Model)model;
    }
}

