/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MultitoolUtil {
    public static void rotateBlock(Level level, BlockPos pos, BlockState state, boolean shiftKeyDown) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction newDirection = shiftKeyDown ? facing.getCounterClockWise() : facing.getClockWise();
            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)newDirection);
        } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            if (facing.getAxis().isVertical()) {
                return;
            }
            Direction newDirection = shiftKeyDown ? facing.getCounterClockWise() : facing.getClockWise();
            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)newDirection);
        } else {
            return;
        }
        level.setBlock(pos, state, 3);
        MultitoolUtil.spawnBlockParticles(level, pos, state);
    }

    private static void spawnBlockParticles(Level level, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            double x = (double)pos.getX() + 0.5 + 0.5 * (double)direction.getStepX();
            double y = (double)pos.getY() + 0.5 + 0.5 * (double)direction.getStepY();
            double z = (double)pos.getZ() + 0.5 + 0.5 * (double)direction.getStepZ();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), x, y, z, (double)direction.getStepX() * 0.1, (double)direction.getStepY() * 0.1, (double)direction.getStepZ() * 0.1);
        }
    }
}

