/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.satisfy.camping.core.world.item.BackpackBlockItem;
import org.jetbrains.annotations.NotNull;

public class BackpackContainer
implements Container,
StackedContentsCompatible {
    private final NonNullList<ItemStack> stacks;
    private final Player player;
    private final EquipmentSlot slot;

    public static BackpackContainer forEquipment(Player p, EquipmentSlot s) {
        ItemStack stack = p.getItemBySlot(s);
        NonNullList<ItemStack> items = BackpackContainer.readFromItem(stack);
        return new BackpackContainer(items, p, s);
    }

    public BackpackContainer(NonNullList<ItemStack> stacks) {
        this(stacks, null, null);
    }

    public BackpackContainer(NonNullList<ItemStack> stacks, Player player, EquipmentSlot slot) {
        this.stacks = stacks;
        this.player = player;
        this.slot = slot;
    }

    public int getContainerSize() {
        return 24;
    }

    public boolean isEmpty() {
        for (ItemStack s : this.stacks) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.stacks.get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        ItemStack out = ContainerHelper.removeItem(this.stacks, (int)i, (int)j);
        if (!out.isEmpty()) {
            this.setChanged();
        }
        return out;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.stacks, (int)i);
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        this.stacks.set(i, (Object)itemStack);
        this.setChanged();
    }

    public boolean stillValid(Player p) {
        return !p.isDeadOrDying();
    }

    public void clearContent() {
        Collections.fill(this.stacks, ItemStack.EMPTY);
        this.setChanged();
    }

    public void fillStackedContents(@NotNull StackedContents sc) {
        for (ItemStack s : this.stacks) {
            sc.accountStack(s);
        }
        this.setChanged();
    }

    public void setChanged() {
        if (this.player == null || this.player.level().isClientSide || this.slot == null) {
            return;
        }
        ItemStack eq = this.player.getItemBySlot(this.slot);
        if (eq.isEmpty() || !(eq.getItem() instanceof BackpackBlockItem)) {
            return;
        }
        eq.remove(DataComponents.BLOCK_ENTITY_DATA);
        if (BackpackContainer.allEmpty(this.stacks)) {
            eq.remove(DataComponents.CONTAINER);
        } else {
            eq.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.stacks));
        }
        this.player.setItemSlot(this.slot, eq);
        this.player.getInventory().setChanged();
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public static void writeToItem(ItemStack stack, NonNullList<ItemStack> items) {
        stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        if (BackpackContainer.allEmpty(items)) {
            stack.remove(DataComponents.CONTAINER);
        } else {
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(items));
        }
    }

    public static NonNullList<ItemStack> readFromItem(ItemStack stack) {
        NonNullList list = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(list);
        return list;
    }

    private static boolean allEmpty(NonNullList<ItemStack> items) {
        for (ItemStack s : items) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }
}

