/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.core.registry.CampingBlockEntities;
import net.satisfy.camping.core.registry.CampingItems;
import net.satisfy.camping.core.util.CampingUtil;
import net.satisfy.camping.core.util.EnderpackVariant;
import net.satisfy.camping.core.world.block.entity.EnderpackBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderpackBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Supplier<VoxelShape> ENDERPACK = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.3125, (double)0.8125, (double)0.625, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.125, (double)0.25, (double)0.6875, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    private static final Supplier<VoxelShape> ENDERBAG = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.4375, (double)0.8125, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.5, (double)0.375, (double)0.5625, (double)0.625, (double)0.4375), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<EnderpackVariant, Map<Direction, VoxelShape>> SHAPES = new HashMap<EnderpackVariant, Map<Direction, VoxelShape>>();
    private final EnderpackVariant variant;
    private final MapCodec<EnderpackBlock> codec;

    public EnderpackBlock(BlockBehaviour.Properties properties, EnderpackVariant variant) {
        super(properties);
        this.variant = variant;
        this.codec = EnderpackBlock.simpleCodec(p -> new EnderpackBlock((BlockBehaviour.Properties)p, this.variant));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fs = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootBuilder) {
        return this.variant == EnderpackVariant.ENDERPACK ? List.of(new ItemStack((ItemLike)CampingItems.ENDERPACK)) : List.of(new ItemStack((ItemLike)CampingItems.ENDERBAG));
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof EnderpackBlock) {
            EnderpackBlock enderpack = (EnderpackBlock)block;
            if (enderpack.variant == EnderpackVariant.ENDERPACK) {
                return new ItemStack((ItemLike)CampingItems.ENDERPACK);
            }
            if (enderpack.variant == EnderpackVariant.ENDERBAG) {
                return new ItemStack((ItemLike)CampingItems.ENDERBAG);
            }
        }
        return ItemStack.EMPTY;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCrouching()) {
            level.destroyBlock(pos, false);
            ItemStack drop = new ItemStack((ItemLike)(this.variant == EnderpackVariant.ENDERPACK ? CampingItems.ENDERPACK : CampingItems.ENDERBAG));
            ItemEntity ie = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
            ie.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)ie);
            return InteractionResult.CONSUME;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> ChestMenu.threeRows((int)id, (Inventory)inv, (Container)player.getEnderChestInventory()), CampingItems.ENDERPACK.getName(new ItemStack((ItemLike)CampingItems.ENDERPACK))));
        player.awardStat(Stats.OPEN_ENDERCHEST);
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 3; ++i) {
            int pm = random.nextInt(2) * 2 - 1;
            int sm = random.nextInt(2) * 2 - 1;
            double x = (double)pos.getX() + 0.5 + 0.25 * (double)pm;
            double y = (float)pos.getY() + random.nextFloat();
            double z = (double)pos.getZ() + 0.5 + 0.25 * (double)sm;
            double vx = random.nextFloat() * (float)pm;
            double vy = ((double)random.nextFloat() - 0.5) * 0.125;
            double vz = random.nextFloat() * (float)sm;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, vx, vy, vz);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EnderpackBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return EnderpackBlock.createTickerHelper(type, CampingBlockEntities.ENDERPACK, (lvl, p, s, be) -> be.tick(lvl, p, s, (EnderpackBlockEntity)be));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide && !state.is(newState.getBlock()) && (be = level.getBlockEntity(pos)) instanceof EnderpackBlockEntity) {
            EnderpackBlockEntity enderpack = (EnderpackBlockEntity)be;
            this.dropSelf(level, pos, enderpack);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void dropSelf(Level level, BlockPos pos, EnderpackBlockEntity be) {
        ItemStack stack = new ItemStack((ItemLike)(this.variant == EnderpackVariant.ENDERPACK ? CampingItems.ENDERPACK : CampingItems.ENDERBAG));
        if (be.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)be.getCustomName());
        }
        ItemEntity ie = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        ie.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)ie);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.variant).get(state.getValue((Property)FACING));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private static Map<Direction, VoxelShape> generateShapes(Supplier<VoxelShape> shapeSupplier) {
        HashMap<Direction, VoxelShape> shapeMap = new HashMap<Direction, VoxelShape>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapeMap.put(direction, CampingUtil.rotateShape(Direction.NORTH, direction, shapeSupplier.get()));
        }
        return shapeMap;
    }

    static {
        SHAPES.put(EnderpackVariant.ENDERPACK, EnderpackBlock.generateShapes(ENDERPACK));
        SHAPES.put(EnderpackVariant.ENDERBAG, EnderpackBlock.generateShapes(ENDERBAG));
    }
}

