/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.camping.core.util.MultitoolUtil;
import org.jetbrains.annotations.NotNull;

public class MultitoolItem
extends Item {
    public MultitoolItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.hasProperty((Property)BlockStateProperties.FACING) && !blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            MultitoolUtil.rotateBlock(level, blockPos, blockState, player.isShiftKeyDown());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.camping.multitool").setStyle(Style.EMPTY.withColor(5597999)));
    }
}

