/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;

public record RecordItemContainer(NonNullList<MutableResourceStack<ItemResource>> resourceStacks, @Nullable Runnable updateCallback) implements IResourceContainer<ItemResource>
{
    public RecordItemContainer(NonNullList<MutableResourceStack<ItemResource>> resourceStacks, @Nullable Runnable updateCallback) {
        Objects.requireNonNull(resourceStacks);
        Objects.checkIndex(0, resourceStacks.size());
    }

    public static RecordItemContainer of(int size) {
        return RecordItemContainer.of(size, null);
    }

    public static RecordItemContainer of(int size, @Nullable Runnable updateCallback) {
        return new RecordItemContainer(MutableResourceStack.Empty.ITEM.nonNullListOfSize(size), updateCallback);
    }

    public static RecordItemContainer from(NonNullList<MutableResourceStack<ItemResource>> items) {
        return RecordItemContainer.from(items, null);
    }

    public static RecordItemContainer from(NonNullList<MutableResourceStack<ItemResource>> items, Runnable updateCallback) {
        RecordItemContainer container = RecordItemContainer.of(items.size(), updateCallback);
        for (int i = 0; i < items.size(); ++i) {
            container.set(i, (MutableResourceStack)items.get(i));
        }
        return container;
    }

    @Override
    @NotNull
    public MutableResourceStack<ItemResource> defaultResource() {
        return MutableResourceStack.Empty.ITEM;
    }

    @Override
    public int size() {
        return this.resourceStacks.size();
    }

    @Override
    public int getCapacity(int index, @NotNull ItemResource resource) {
        Objects.checkIndex(index, this.size());
        return resource.getMaxStackSize();
    }

    @Override
    public int getCapacity(int index) {
        Objects.checkIndex(index, this.size());
        return 99;
    }

    @Override
    @NotNull
    public MutableResourceStack<ItemResource> get(int index) {
        Objects.checkIndex(index, this.size());
        return (MutableResourceStack)this.resourceStacks.get(index);
    }

    @Override
    public void set(int index, @NotNull MutableResourceStack<ItemResource> stack) {
        Objects.checkIndex(index, this.size());
        this.resourceStacks.set(index, stack);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public void clear() {
        Collections.fill(this.resourceStacks, this.defaultResource());
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    @NotNull
    public IResourceContainer<ItemResource> slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    private class Slice
    implements IResourceContainer<ItemResource> {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        @NotNull
        public MutableResourceStack<ItemResource> defaultResource() {
            return RecordItemContainer.this.defaultResource();
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        @NotNull
        public MutableResourceStack<ItemResource> get(int index) {
            Objects.checkIndex(index, this.size());
            return RecordItemContainer.this.get(index + this.start);
        }

        @Override
        public void set(int index, @NotNull MutableResourceStack<ItemResource> stack) {
            Objects.checkIndex(index, this.size());
            RecordItemContainer.this.set(index + this.start, stack);
        }

        @Override
        public int getCapacity(int index, @NotNull ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return RecordItemContainer.this.getCapacity(index + this.start, resource);
        }

        @Override
        public int getCapacity(int index) {
            Objects.checkIndex(index, this.size());
            return RecordItemContainer.this.getCapacity(index + this.start);
        }

        @Override
        public boolean isValid(int index, @NotNull ItemResource stack) {
            Objects.checkIndex(index, this.size());
            return RecordItemContainer.this.isValid(index + this.start, stack);
        }

        @Override
        public void clear() {
            for (int index = 0; index < this.length; ++index) {
                Objects.checkIndex(index, this.size());
                RecordItemContainer.this.resourceStacks.set(index + this.start, this.defaultResource());
            }
            if (RecordItemContainer.this.updateCallback != null) {
                RecordItemContainer.this.updateCallback.run();
            }
        }

        @Override
        @NotNull
        public IResourceContainer<ItemResource> slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return RecordItemContainer.this.slice(this.start + from, to - from);
        }
    }
}

