/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item2;

import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandlerModifiable;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;

public record ItemHandlerToContainerAdapter(IResourceHandler<ItemResource> itemHandler) implements IResourceContainer<ItemResource>
{
    @Override
    public int size() {
        return this.itemHandler.size();
    }

    @Override
    @NotNull
    public MutableResourceStack<ItemResource> get(int index) {
        ItemResource resource = this.itemHandler.getResource(index);
        if (resource.isEmpty()) {
            return this.defaultResource();
        }
        return MutableResourceStack.of(resource, this.itemHandler.getAmount(index));
    }

    @Override
    public void set(int index, @NotNull MutableResourceStack<ItemResource> stack) {
        IResourceHandler<ItemResource> iResourceHandler = this.itemHandler;
        if (iResourceHandler instanceof IResourceHandlerModifiable) {
            IResourceHandlerModifiable modifiable = (IResourceHandlerModifiable)iResourceHandler;
            modifiable.set(index, stack.resource(), stack.amount());
            return;
        }
        ItemResource resource = this.itemHandler.getResource(index);
        if (!resource.isEmpty()) {
            this.itemHandler.extract(index, resource, Integer.MAX_VALUE, TransferAction.EXECUTE);
        }
        this.itemHandler.insert(index, stack.resource(), stack.amount(), TransferAction.EXECUTE);
    }

    @Override
    public boolean isValid(int index, @NotNull ItemResource resource) {
        return this.itemHandler.isValid(index, resource);
    }

    @Override
    public int getCapacity(int index, @NotNull ItemResource resource) {
        return this.itemHandler.getCapacity(index, resource);
    }

    @Override
    public int getCapacity(int index) {
        return this.itemHandler.getCapacity(index);
    }

    @Override
    @Nonnull
    @NotNull
    public IResourceHandlerModifiable<ItemResource> asHandler() {
        IResourceHandlerModifiable modifiable;
        IResourceHandler<ItemResource> iResourceHandler = this.itemHandler;
        return iResourceHandler instanceof IResourceHandlerModifiable ? (modifiable = (IResourceHandlerModifiable)iResourceHandler) : IResourceContainer.super.asHandler();
    }

    @Override
    @NotNull
    public MutableResourceStack<ItemResource> defaultResource() {
        return MutableResourceStack.Empty.ITEM;
    }
}

