/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import java.util.EnumMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.RegistrationContentBuilder;

public class ColoredItemContentRegistrationBuilder<TColor extends Enum<TColor> & IColorSource>
extends RegistrationContentBuilder<ColoredItemContentRegistrationBuilder<TColor>, EnumMap<TColor, ItemContent>> {
    private Function<Item.Properties, Item.Properties> _itemProperties = Function.identity();
    private final BiFunction<TColor, Item.Properties, Item> _itemFactory;
    private final Class<TColor> _class;
    private DeferredHolder<CreativeModeTab, CreativeModeTab> _tab;
    private BiConsumer<TColor, ItemContent> _contentConsumer = (tColor, itemContent) -> {};

    public ColoredItemContentRegistrationBuilder(ContentMap map, Class<TColor> c, String contentId, BiFunction<TColor, Item.Properties, Item> factory) {
        super(map, contentId);
        this._itemFactory = factory;
        this._class = c;
    }

    public ColoredItemContentRegistrationBuilder<TColor> withTab(@Nullable DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    public ColoredItemContentRegistrationBuilder<TColor> withProperties(Function<Item.Properties, Item.Properties> itemProperties) {
        this._itemProperties = itemProperties;
        return this;
    }

    public ColoredItemContentRegistrationBuilder<TColor> withConsumer(BiConsumer<TColor, ItemContent> contentConsumer) {
        this._contentConsumer = contentConsumer;
        return this;
    }

    @Override
    public EnumMap<TColor, ItemContent> build() {
        return (EnumMap)Util.make(new EnumMap(this._class), map -> {
            for (Enum color : (Enum[])this._class.getEnumConstants()) {
                ItemContent content = new ItemContent((DeferredItem<Item>)this._map.ItemMap.register(this.Id + "_" + ((StringRepresentable)color).getSerializedName(), () -> this._itemFactory.apply(color, this._itemProperties.apply(new Item.Properties()))));
                this._map.ListOfItems.add(content);
                this._map.MappedContent.add(content);
                this._localizations.forEach((mcLocale, name) -> content.withName(mcLocale.toString(), name.formatted(color.name())));
                map.put(color, content);
                content.setTab((DeferredHolder)this._tab);
                content.requires(this._requirement);
                this._contentConsumer.accept(color, content);
            }
        });
    }
}

