/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.volumes;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.level.LevelEvent;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.volumes.ICacheableVolume;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME)
public record HydrationVolume(BlockPos pos) implements ICacheableVolume
{
    public static final AttachmentType.Builder<VolumeLevelAttachment<HydrationVolume>> Builder = VolumeLevelAttachment.builder(HydrationVolume.class, HydrationVolume::new);

    @Override
    public int getRange() {
        return 4;
    }

    @Override
    public BlockPos getPos() {
        return this.pos();
    }

    @Override
    public boolean isStateValid(BlockState blockState) {
        return blockState.is(CompatContent.XyCraftMachines.Blocks.WaterBlockKey);
    }

    @SubscribeEvent
    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        VolumeLevelAttachment.load(serverLevel, CoreAttachments.HydrationVolumeData);
    }
}

