/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.mixins;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FarmBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import tv.soaryn.xycraft.core.content.volumes.HydrationVolume;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;

@Mixin(value={FarmBlock.class})
public class FarmHydrationMixin {
    @Inject(method={"isNearWater"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void isInWaterVolume(LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && FastVolumeLookup.of((Level)(serverLevel = (ServerLevel)level), HydrationVolume.class).find(pos).findAny().isPresent()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }
}

