/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.ArrayUtils;

public final class Utils {
    public static Supplier<Level> CLIENT_LEVEL_SUPPLIER = () -> null;
    public static Supplier<Player> CLIENT_PLAYER_SUPPLIER = () -> null;
    public static BooleanSupplier SHIFT_KEY_DOWN = () -> false;
    public static BooleanSupplier DEBUG_SCREEN = () -> false;
    public static Supplier<FeatureFlag[]> EXPERIMENTAL_FLAG = () -> new FeatureFlag[]{FeatureFlags.BUNDLE};
    private static final Direction[][] ROTATION_PLANES = new Direction[][]{{Direction.DOWN, Direction.SOUTH, Direction.UP, Direction.NORTH}, {Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST}, {Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST}};

    private Utils() {
    }

    public static Player getClientPlayer() {
        return CLIENT_PLAYER_SUPPLIER.get();
    }

    public static Level getClientLevel() {
        return CLIENT_LEVEL_SUPPLIER.get();
    }

    public static boolean isDebugScreenOn() {
        return DEBUG_SCREEN.getAsBoolean();
    }

    public static void classLoad(Object ... objects) {
    }

    public static byte set(byte value, int position, boolean state) {
        if (state) {
            return (byte)(value | 1 << position);
        }
        return (byte)(value & ~(1 << position));
    }

    public static <T> T cycle(T[] arr, T current) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        int idx = (currentIdx + 1) % arr.length;
        return arr[idx];
    }

    public static <T> T cycleConditionally(T[] arr, T current, Predicate<T> predicate) {
        int currentIdx = ArrayUtils.indexOf((Object[])arr, current);
        for (int i = 0; i < arr.length - 1; ++i) {
            int idx = (currentIdx + i + 1) % arr.length;
            T candidate = arr[idx];
            if (!predicate.test(candidate)) continue;
            return candidate;
        }
        return current;
    }

    public static <T> T[] rotateArray(T[] arr, Rotation rotation) {
        T[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.rotate((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static int[] rotateArray(int[] arr, Rotation rotation) {
        int[] newArr = Arrays.copyOf(arr, arr.length);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            newArr[rotation.rotate((Direction)direction).ordinal()] = arr[direction.ordinal()];
        }
        return newArr;
    }

    public static BlockState resolveHit(BlockGetter level, BlockHitResult hit) {
        return level.getBlockState(hit.getBlockPos());
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newFilledEnumMap(Class<K> keyType, Function<K, V> valueMapper) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            map.put(key, valueMapper.apply(key));
        }
        return map;
    }

    public static <T> List<T> newFilledList(int size, Supplier<T> entryFactory) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(entryFactory.get());
        }
        return list;
    }

    public static <T> List<T> newFilledList(int size, IntFunction<T> entryFactory) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(entryFactory.apply(i));
        }
        return list;
    }

    public static ItemEntity dropItemAt(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public static ItemEntity dropItemOutwardsAtSide(Level level, BlockPos pos, Direction side, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, (double)((float)pos.getX() + ((float)side.getStepX() * 1.5f + 1.0f) / 2.0f), (double)((float)pos.getY() + ((float)side.getStepY() * 1.5f + 1.0f) / 2.0f), (double)((float)pos.getZ() + ((float)side.getStepZ() * 1.5f + 1.0f) / 2.0f), stack, (double)((float)side.getStepX() * 0.2f + level.random.nextFloat() * 0.1f - 0.05f), (double)((float)side.getStepY() * 0.2f + level.random.nextFloat() * 0.1f - 0.05f), (double)((float)side.getStepZ() * 0.2f + level.random.nextFloat() * 0.1f - 0.05f));
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    @Nullable
    public static <T> TagKey<T> loadTagKey(CompoundTag tag, Function<ResourceLocation, TagKey<T>> factory) {
        String string = tag.getString("tag");
        if (string.isEmpty()) {
            return null;
        }
        return factory.apply(ResourceLocation.parse((String)string));
    }

    @Nullable
    public static Direction.AxisDirection getAxisDirection(int value) {
        if (value == 0) {
            return null;
        }
        return value > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    @Nullable
    public static Direction getDirection(Vec3i vector) {
        int x = vector.getX();
        int y = vector.getY();
        int z = vector.getZ();
        if (x * y == x + y) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(vector.getZ());
            return axisDirection != null ? Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)axisDirection) : null;
        }
        if (x * z == x + z) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(y);
            return axisDirection != null ? Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)axisDirection) : null;
        }
        if (y * z == y + z) {
            Direction.AxisDirection axisDirection = Utils.getAxisDirection(x);
            return axisDirection != null ? Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)axisDirection) : null;
        }
        return null;
    }

    public static Direction rotate(Direction direction, Direction.Axis axis, Rotation rotation) {
        if (axis == direction.getAxis()) {
            return direction;
        }
        List<Direction> plane = Arrays.asList(ROTATION_PLANES[axis.ordinal()]);
        int currentIndex = plane.indexOf(direction);
        int newIndex = rotation.rotate(currentIndex, plane.size());
        return plane.get(newIndex);
    }
}

