/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class DyedBEList<T extends BlockEntity>
implements Iterable<BlockEntityEntry<T>> {
    private static final int COLOR_AMOUNT = DyeColor.values().length;
    private final BlockEntityEntry<?>[] values = new BlockEntityEntry[COLOR_AMOUNT];

    public DyedBEList(Function<DyeColor, BlockEntityEntry<? extends T>> filler) {
        for (DyeColor color : DyeColor.values()) {
            this.values[color.ordinal()] = filler.apply(color);
        }
    }

    public BlockEntityEntry<T> get(DyeColor color) {
        return this.values[color.ordinal()];
    }

    public boolean contains(Block block) {
        for (BlockEntityEntry<?> entry : this.values) {
            if (!entry.is((Object)block)) continue;
            return true;
        }
        return false;
    }

    public BlockEntityEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<BlockEntityEntry<T>> iterator() {
        return new Iterator<BlockEntityEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DyedBEList.this.values.length;
            }

            @Override
            public BlockEntityEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DyedBEList.this.values[this.index++];
            }
        };
    }
}

