/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines;

import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidContainingItem
extends Item {
    public final FluidEntry<?> fluid;
    public static final int CAPACITY = 4000;

    public FluidContainingItem(Item.Properties p_41383_, FluidEntry<?> fluid) {
        super(p_41383_);
        this.fluid = fluid;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)TFMGLang.translateDirect("tooltip.fluid_item", stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0)).withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isBarVisible(ItemStack stack) {
        if (!stack.has(TFMGDataComponents.AMOUNT)) {
            return false;
        }
        return (Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0) > 0;
    }

    public int getBarColor(ItemStack stack) {
        if (!stack.has(TFMGDataComponents.AMOUNT)) {
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
        }
        return 13092004;
    }

    public int getBarWidth(ItemStack stack) {
        if (!stack.has(TFMGDataComponents.AMOUNT)) {
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
        }
        return Math.round(13.0f * ((float)((Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0)).intValue() / 4000.0f));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (context.getPlayer().isShiftKeyDown() && (Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0) > 0) {
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockEntity(pos) != null && (blockEntity = level.getBlockEntity(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity be;
            FluidTankBlockEntity fluidTankBe = (FluidTankBlockEntity)blockEntity;
            FluidTankBlockEntity fluidTankBlockEntity = be = fluidTankBe.isController() ? fluidTankBe : fluidTankBe.getControllerBE();
            if (be.getFluid(0).getFluid().isSame((Fluid)this.fluid.get())) {
                int toDrain = Math.min(4000 - (Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0), be.getFluid(0).getAmount());
                if (toDrain == 0 || context.getPlayer().getCooldowns().isOnCooldown(stack.getItem())) {
                    return InteractionResult.PASS;
                }
                level.playSound(null, be.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                be.getTankInventory().drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                stack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)stack.getOrDefault(TFMGDataComponents.AMOUNT, (Object)0) + toDrain));
                context.getPlayer().getCooldowns().addCooldown(stack.getItem(), 20);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

