/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.gas_lamp;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.gas_lamp.GasLampBlock;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class GasLampBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public FluidTank tankInventory = this.createInventory();
    public int lightTimer = 0;

    public GasLampBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(this, 4000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().is(TFMGTags.TFMGFluidTags.FLAMMABLE.tag) || stack.getFluid().is(TFMGTags.TFMGFluidTags.FUEL.tag);
            }
        };
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        this.sendData();
        this.setChanged();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    public void tick() {
        super.tick();
        if (this.tankInventory.isEmpty() || !this.tankInventory.isFluidValid(this.tankInventory.getFluid())) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)GasLampBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
            return;
        }
        if (this.tankInventory.getFluidAmount() > 0) {
            if (this.level.random.nextInt(20) == 0) {
                this.tankInventory.drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            this.lightTimer = 100;
        }
        if (this.lightTimer > 0) {
            --this.lightTimer;
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)GasLampBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

