/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.datagen.recipes;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGRegistrate;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGCompactingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGCrushingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGDeployingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGFillingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGItemApplicationRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGMixingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGPressingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGCastingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGCokingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGDistillationRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGHotBlastRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGIndustrialBlastingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGPolarizingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGVatRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.TFMGWindingRecipeGen;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class TFMGRecipeProvider
extends RecipeProvider {
    static final List<ProcessingRecipeGen<?, ?, ?>> GENERATORS = new ArrayList();
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public TFMGRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        this.all.forEach(c -> c.register(pRecipeOutput));
        TFMG.LOGGER.info("{} registered {} recipe{}", new Object[]{this.getName(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    public static void registerAllProcessing(DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGCokingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGDistillationRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGWindingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGPolarizingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGHotBlastRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGCastingRecipeGen(output, registries));
        GENERATORS.add(new TFMGIndustrialBlastingRecipeGen(output, registries));
        GENERATORS.add(new TFMGVatRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGPressingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGItemApplicationRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGFillingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGMixingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGCompactingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGCrushingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new TFMGDeployingRecipeGen(output, registries));
        gen.addProvider(true, new DataProvider(){

            public String getName() {
                return "TFMG's Processing Recipes";
            }

            public CompletableFuture<?> run(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(RecipeOutput var1);
    }

    public static class F {
        public static Fluid air() {
            return (Fluid)TFMGFluids.AIR.get();
        }

        public static Fluid hotAir() {
            return (Fluid)TFMGFluids.HOT_AIR.get();
        }

        public static Fluid carbonDioxide() {
            return (Fluid)TFMGFluids.CARBON_DIOXIDE.get();
        }

        public static Fluid ethylene() {
            return (Fluid)TFMGFluids.ETHYLENE.get();
        }

        public static Fluid propylene() {
            return (Fluid)TFMGFluids.PROPYLENE.get();
        }

        public static Fluid propane() {
            return (Fluid)TFMGFluids.PROPANE.get();
        }

        public static Fluid hydrogen() {
            return (Fluid)TFMGFluids.HYDROGEN.get();
        }

        public static Fluid butane() {
            return (Fluid)TFMGFluids.BUTANE.get();
        }

        public static Fluid lpg() {
            return (Fluid)TFMGFluids.LPG.get();
        }

        public static Fluid neon() {
            return (Fluid)TFMGFluids.NEON.get();
        }

        public static Fluid blastFurnaceGas() {
            return (Fluid)TFMGFluids.FURNACE_GAS.get();
        }

        public static Fluid crudeOil() {
            return (Fluid)TFMGFluids.CRUDE_OIL.get();
        }

        public static Fluid heavyOil() {
            return (Fluid)TFMGFluids.HEAVY_OIL.get();
        }

        public static Fluid lubricationOil() {
            return (Fluid)TFMGFluids.LUBRICATION_OIL.get();
        }

        public static Fluid napalm() {
            return (Fluid)TFMGFluids.NAPALM.get();
        }

        public static Fluid naphtha() {
            return (Fluid)TFMGFluids.NAPHTHA.get();
        }

        public static Fluid kerosene() {
            return (Fluid)TFMGFluids.KEROSENE.get();
        }

        public static Fluid gasoline() {
            return (Fluid)TFMGFluids.GASOLINE.get();
        }

        public static Fluid diesel() {
            return (Fluid)TFMGFluids.DIESEL.get();
        }

        public static Fluid creosote() {
            return (Fluid)TFMGFluids.CREOSOTE.get();
        }

        public static Fluid water() {
            return Fluids.WATER;
        }

        public static Fluid coolingFluid() {
            return (Fluid)TFMGFluids.COOLING_FLUID.get();
        }

        public static Fluid sulfuricAcid() {
            return (Fluid)TFMGFluids.SULFURIC_ACID.get();
        }

        public static Fluid liquidConcrete() {
            return (Fluid)TFMGFluids.LIQUID_CONCRETE.get();
        }

        public static Fluid liquidAsphalt() {
            return (Fluid)TFMGFluids.LIQUID_ASPHALT.get();
        }

        public static Fluid liquidPlastic() {
            return (Fluid)TFMGFluids.MOLTEN_PLASTIC.get();
        }

        public static Fluid moltenSteel() {
            return (Fluid)TFMGFluids.MOLTEN_STEEL.get();
        }

        public static Fluid moltenSlag() {
            return (Fluid)TFMGFluids.MOLTEN_SLAG.get();
        }

        public static Fluid potion() {
            return (Fluid)AllFluids.POTION.get();
        }

        public static ItemLike airTank() {
            return TFMGRegistrate.getBucket("air");
        }

        public static ItemLike hotAirTank() {
            return TFMGRegistrate.getBucket("hot_air");
        }

        public static ItemLike carbonDioxideTank() {
            return TFMGRegistrate.getBucket("carbon_dioxide");
        }

        public static ItemLike ethyleneTank() {
            return TFMGRegistrate.getBucket("ethylene");
        }

        public static ItemLike propyleneTank() {
            return TFMGRegistrate.getBucket("propylene");
        }

        public static ItemLike propaneTank() {
            return TFMGRegistrate.getBucket("propane");
        }

        public static ItemLike hydrogenTank() {
            return TFMGRegistrate.getBucket("hydrogen");
        }

        public static ItemLike butaneTank() {
            return TFMGRegistrate.getBucket("butane");
        }

        public static ItemLike lpgTank() {
            return TFMGRegistrate.getBucket("lpg");
        }

        public static ItemLike neonTank() {
            return TFMGRegistrate.getBucket("neon");
        }

        public static ItemLike furnaceGasTank() {
            return TFMGRegistrate.getBucket("furnace_gas");
        }

        public static ItemLike crudeOilBucket() {
            return TFMGRegistrate.getBucket("crude_oil");
        }

        public static ItemLike heavyOilBucket() {
            return TFMGRegistrate.getBucket("heavy_oil");
        }

        public static ItemLike lubricationOilBucket() {
            return TFMGRegistrate.getBucket("lubrication_oil");
        }

        public static ItemLike napalmBucket() {
            return TFMGRegistrate.getBucket("napalm");
        }

        public static ItemLike naphthaBucket() {
            return TFMGRegistrate.getBucket("naphtha");
        }

        public static ItemLike keroseneBucket() {
            return TFMGRegistrate.getBucket("kerosene");
        }

        public static ItemLike gasolineBucket() {
            return TFMGRegistrate.getBucket("gasoline");
        }

        public static ItemLike dieselBucket() {
            return TFMGRegistrate.getBucket("diesel");
        }

        public static ItemLike creosoteBucket() {
            return TFMGRegistrate.getBucket("creosote");
        }

        public static ItemLike coolingFluidBucket() {
            return TFMGRegistrate.getBucket("cooling_fluid");
        }

        public static ItemLike sulfuricAcidBucket() {
            return TFMGRegistrate.getBucket("sulfuric_acid");
        }

        public static ItemLike liquidConcreteBucket() {
            return TFMGRegistrate.getBucket("liquid_concrete");
        }

        public static ItemLike liquidAsphaltBucket() {
            return TFMGRegistrate.getBucket("liquid_asphalt");
        }

        public static ItemLike liquidPlasticBucket() {
            return TFMGRegistrate.getBucket("liquid_plastic");
        }

        public static ItemLike moltenSteelBucket() {
            return TFMGRegistrate.getBucket("molten_steel");
        }

        public static ItemLike moltenSlagBucket() {
            return TFMGRegistrate.getBucket("molten_slag");
        }

        public static ItemLike waterBucket() {
            return Fluids.WATER.getBucket();
        }
    }

    public static class I {
        public static ItemLike tfmgSteelIngot() {
            return TFMGItems.STEEL_INGOT;
        }

        public static ItemLike coal() {
            return Items.COAL;
        }

        public static ItemLike charcoal() {
            return Items.CHARCOAL;
        }

        public static ItemLike coalCoke() {
            return (ItemLike)TFMGItems.COAL_COKE.get();
        }

        public static ItemLike coalCokeDust() {
            return (ItemLike)TFMGItems.COAL_COKE_DUST.get();
        }

        public static TagKey<Item> steelIngot() {
            return AllTags.commonItemTag((String)"ingots/steel");
        }

        public static TagKey<Item> steelNugget() {
            return AllTags.commonItemTag((String)"nuggets/steel");
        }

        public static TagKey<Item> steelSheet() {
            return AllTags.commonItemTag((String)"plates/steel");
        }

        public static TagKey<Item> steelBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/steel");
        }

        public static TagKey<Item> aluminumIngot() {
            return AllTags.commonItemTag((String)"ingots/aluminum");
        }

        public static TagKey<Item> aluminumNugget() {
            return AllTags.commonItemTag((String)"nuggets/aluminum");
        }

        public static TagKey<Item> aluminumBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/aluminum");
        }

        public static TagKey<Item> aluminumSheet() {
            return AllTags.commonItemTag((String)"plates/aluminum");
        }

        public static TagKey<Item> castIronIngot() {
            return AllTags.commonItemTag((String)"ingots/cast_iron");
        }

        public static TagKey<Item> castIronNugget() {
            return AllTags.commonItemTag((String)"nuggets/cast_iron");
        }

        public static TagKey<Item> castIronBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/cast_iron");
        }

        public static TagKey<Item> castIronSheet() {
            return AllTags.commonItemTag((String)"plates/cast_iron");
        }

        public static TagKey<Item> leadIngot() {
            return AllTags.commonItemTag((String)"ingots/lead");
        }

        public static TagKey<Item> leadNugget() {
            return AllTags.commonItemTag((String)"nuggets/lead");
        }

        public static TagKey<Item> leadSheet() {
            return AllTags.commonItemTag((String)"plates/lead");
        }

        public static TagKey<Item> leadBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/lead");
        }

        public static TagKey<Item> nickelIngot() {
            return AllTags.commonItemTag((String)"ingots/nickel");
        }

        public static TagKey<Item> nickelNugget() {
            return AllTags.commonItemTag((String)"nuggets/nickel");
        }

        public static TagKey<Item> nickelBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/nickel");
        }

        public static TagKey<Item> nickelSheet() {
            return AllTags.commonItemTag((String)"plates/nickel");
        }

        public static TagKey<Item> lithiumIngot() {
            return AllTags.commonItemTag((String)"ingots/lithium");
        }

        public static TagKey<Item> lithiumNugget() {
            return AllTags.commonItemTag((String)"nuggets/lithium");
        }

        public static TagKey<Item> lithiumBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/lithium");
        }

        public static TagKey<Item> constantanIngot() {
            return AllTags.commonItemTag((String)"ingots/constantan");
        }

        public static TagKey<Item> constantanNugget() {
            return AllTags.commonItemTag((String)"nuggets/constantan");
        }

        public static TagKey<Item> constantanBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/constantan");
        }

        public static TagKey<Item> copperWire() {
            return AllTags.commonItemTag((String)"wires/copper");
        }

        public static TagKey<Item> constantanWire() {
            return AllTags.commonItemTag((String)"wires/constantan");
        }

        public static TagKey<Item> aluminumWire() {
            return AllTags.commonItemTag((String)"wires/aluminum");
        }

        public static ItemLike bitumen() {
            return (ItemLike)TFMGItems.BITUMEN.get();
        }

        public static ItemLike cinderFlour() {
            return (ItemLike)AllItems.CINDER_FLOUR.get();
        }

        public static ItemLike plasticSheet() {
            return (ItemLike)TFMGItems.PLASTIC_SHEET.get();
        }

        public static ItemLike crimsite() {
            return (ItemLike)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get();
        }

        public static ItemLike thermitePowder() {
            return (ItemLike)TFMGItems.THERMITE_POWDER.get();
        }

        public static ItemLike crushedRawAluminum() {
            return (ItemLike)AllItems.CRUSHED_BAUXITE.get();
        }

        public static ItemLike experienceNugget() {
            return (ItemLike)AllItems.EXP_NUGGET.get();
        }

        public static ItemLike capacitor() {
            return TFMGItems.CAPACITOR;
        }

        public static ItemLike copperSulfate() {
            return (ItemLike)TFMGItems.COPPER_SULFATE.get();
        }

        public static ItemLike boneMeal() {
            return Items.BONE_MEAL;
        }

        public static ItemLike blueDye() {
            return Items.BLUE_DYE;
        }

        public static ItemLike greenDye() {
            return Items.GREEN_DYE;
        }

        public static ItemLike cyanDye() {
            return Items.CYAN_DYE;
        }

        public static ItemLike crushedRawLead() {
            return (ItemLike)AllItems.CRUSHED_LEAD.get();
        }

        public static ItemLike limestone() {
            return (ItemLike)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get();
        }

        public static ItemLike limesand() {
            return (ItemLike)TFMGItems.LIMESAND.get();
        }

        public static ItemLike dirt() {
            return Items.DIRT;
        }

        public static ItemLike rebar() {
            return (ItemLike)TFMGItems.REBAR.get();
        }

        public static ItemLike nitrateDust() {
            return (ItemLike)TFMGItems.NITRATE_DUST.get();
        }

        public static ItemLike sulfurDust() {
            return (ItemLike)TFMGItems.SULFUR_DUST.get();
        }

        public static ItemLike bucket() {
            return Items.BUCKET;
        }

        public static ItemLike bottle() {
            return Items.GLASS_BOTTLE;
        }

        public static ItemLike potato() {
            return Items.POTATO;
        }

        public static ItemLike napalmPotato() {
            return (ItemLike)TFMGItems.NAPALM_POTATO.get();
        }

        public static ItemLike heavyMachineryCasing() {
            return (ItemLike)TFMGBlocks.HEAVY_MACHINERY_CASING.get();
        }

        public static ItemLike steelCasing() {
            return (ItemLike)TFMGBlocks.STEEL_CASING.get();
        }

        public static ItemLike aluminumCasing() {
            return (ItemLike)TFMGBlocks.ALUMINUM_CASING.get();
        }

        public static ItemLike lightBulb() {
            return (ItemLike)TFMGBlocks.LIGHT_BULB.get();
        }

        public static ItemLike heavyPlate() {
            return (ItemLike)TFMGItems.HEAVY_PLATE.get();
        }

        public static ItemLike castIronSheetTFMG() {
            return (ItemLike)TFMGItems.CAST_IRON_SHEET.get();
        }

        public static ItemLike nickelSheetTFMG() {
            return (ItemLike)TFMGItems.NICKEL_SHEET.get();
        }

        public static ItemLike leadSheetTFMG() {
            return (ItemLike)TFMGItems.LEAD_SHEET.get();
        }

        public static ItemLike aluminumSheetTFMG() {
            return (ItemLike)TFMGItems.ALUMINUM_SHEET.get();
        }

        public static ItemLike crushedRawIron() {
            return (ItemLike)AllItems.CRUSHED_IRON.get();
        }

        public static ItemLike ironIngot() {
            return Items.IRON_INGOT;
        }

        public static ItemLike clayBall() {
            return Items.CLAY_BALL;
        }

        public static ItemLike sand() {
            return Items.SAND;
        }

        public static ItemLike gravel() {
            return Items.GRAVEL;
        }

        public static ItemLike concreteMixture() {
            return (ItemLike)TFMGItems.CONCRETE_MIXTURE.get();
        }

        public static ItemLike asphaltMixture() {
            return (ItemLike)TFMGItems.ASPHALT_MIXTURE.get();
        }

        public static ItemLike slag() {
            return (ItemLike)TFMGItems.SLAG.get();
        }

        public static ItemLike gunpowder() {
            return Items.GUNPOWDER;
        }

        public static ItemLike steelTank() {
            return TFMGBlocks.STEEL_FLUID_TANK;
        }

        public static ItemLike castIronTank() {
            return TFMGBlocks.CAST_IRON_FLUID_TANK;
        }

        public static ItemLike circuitBoard() {
            return TFMGItems.CIRCUIT_BOARD;
        }

        public static ItemLike cement() {
            return TFMGBlocks.CEMENT;
        }

        public static ItemLike aluminumTank() {
            return TFMGBlocks.ALUMINUM_FLUID_TANK;
        }

        public static ItemLike syntheticLeather() {
            return (ItemLike)TFMGItems.SYNTHETIC_LEATHER.get();
        }

        public static ItemLike engineChamber() {
            return (ItemLike)TFMGItems.ENGINE_CYLINDER.get();
        }

        public static ItemLike screw() {
            return (ItemLike)TFMGItems.SCREW.get();
        }

        public static ItemLike steelMechanism() {
            return (ItemLike)TFMGItems.STEEL_MECHANISM.get();
        }

        public static ItemLike industrialPipe() {
            return (ItemLike)TFMGBlocks.INDUSTRIAL_PIPE.get();
        }

        public static ItemLike steelPipe() {
            return TFMGPipes.PIPES.get((Object)TFMGPipes.PipeMaterial.STEEL).getPipe();
        }

        public static ItemLike brassPipe() {
            return TFMGPipes.PIPES.get((Object)TFMGPipes.PipeMaterial.BRASS).getPipe();
        }

        public static ItemLike castIronPipe() {
            return TFMGPipes.PIPES.get((Object)TFMGPipes.PipeMaterial.CAST_IRON).getPipe();
        }

        public static ItemLike aluminumPipe() {
            return TFMGPipes.PIPES.get((Object)TFMGPipes.PipeMaterial.ALUMINUM).getPipe();
        }

        public static ItemLike plasticPipe() {
            return TFMGPipes.PIPES.get((Object)TFMGPipes.PipeMaterial.PLASTIC).getPipe();
        }

        public static ItemLike magneticIngot() {
            return (ItemLike)TFMGItems.MAGNETIC_ALLOY_INGOT.get();
        }

        public static ItemLike magnet() {
            return (ItemLike)TFMGItems.MAGNET.get();
        }

        public static TagKey<Item> redstone() {
            return Tags.Items.DUSTS_REDSTONE;
        }

        public static TagKey<Item> planks() {
            return ItemTags.PLANKS;
        }

        public static TagKey<Item> woodSlab() {
            return ItemTags.WOODEN_SLABS;
        }

        public static TagKey<Item> log() {
            return ItemTags.LOGS_THAT_BURN;
        }

        public static TagKey<Item> gold() {
            return AllTags.commonItemTag((String)"ingots/gold");
        }

        public static TagKey<Item> string() {
            return AllTags.commonItemTag((String)"string");
        }

        public static ItemLike propeller() {
            return (ItemLike)AllItems.PROPELLER.get();
        }

        public static ItemLike framedGlass() {
            return AllPaletteBlocks.FRAMED_GLASS;
        }

        public static ItemLike steelTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(0).get();
        }

        public static ItemLike steelFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(0).get();
        }

        public static ItemLike aluminumTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(1).get();
        }

        public static ItemLike aluminumFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(1).get();
        }

        public static ItemLike castIronTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(2).get();
        }

        public static ItemLike castIronFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(2).get();
        }

        public static ItemLike leadTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(3).get();
        }

        public static ItemLike leadFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(3).get();
        }

        public static ItemLike nickelTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(4).get();
        }

        public static ItemLike nickelFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(4).get();
        }

        public static ItemLike constantanTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(5).get();
        }

        public static ItemLike constantanFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(5).get();
        }

        public static ItemLike copperTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(6).get();
        }

        public static ItemLike copperFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(6).get();
        }

        public static ItemLike zincTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(7).get();
        }

        public static ItemLike zincFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(7).get();
        }

        public static ItemLike brassTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(8).get();
        }

        public static ItemLike brassFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(8).get();
        }

        public static TagKey<Item> goldSheet() {
            return AllTags.commonItemTag((String)"plates/gold");
        }

        public static ItemLike andesite() {
            return (ItemLike)AllItems.ANDESITE_ALLOY.get();
        }

        public static ItemLike fireproofBricks() {
            return (ItemLike)TFMGBlocks.FIREPROOF_BRICKS.get();
        }

        public static ItemLike shaft() {
            return (ItemLike)AllBlocks.SHAFT.get();
        }

        public static ItemLike cog() {
            return (ItemLike)AllBlocks.COGWHEEL.get();
        }

        public static ItemLike rubber() {
            return (ItemLike)TFMGItems.RUBBER_SHEET.get();
        }

        public static ItemLike largeCog() {
            return (ItemLike)AllBlocks.LARGE_COGWHEEL.get();
        }

        public static ItemLike andesiteCasing() {
            return (ItemLike)AllBlocks.ANDESITE_CASING.get();
        }

        public static TagKey<Item> brassIngot() {
            return AllTags.commonItemTag((String)"ingots/brass");
        }

        public static TagKey<Item> brassSheet() {
            return AllTags.commonItemTag((String)"plates/brass");
        }

        public static TagKey<Item> iron() {
            return Tags.Items.INGOTS_IRON;
        }

        public static TagKey<Item> ironNugget() {
            return AllTags.commonItemTag((String)"nuggets/iron");
        }

        public static TagKey<Item> ironDust() {
            return AllTags.commonItemTag((String)"dusts/iron");
        }

        public static TagKey<Item> zincIngot() {
            return AllTags.commonItemTag((String)"ingots/zinc");
        }

        public static TagKey<Item> ironSheet() {
            return AllTags.commonItemTag((String)"plates/iron");
        }

        public static TagKey<Item> sturdySheet() {
            return AllTags.commonItemTag((String)"plates/obsidian");
        }

        public static ItemLike brassCasing() {
            return (ItemLike)AllBlocks.BRASS_CASING.get();
        }

        public static ItemLike railwayCasing() {
            return (ItemLike)AllBlocks.RAILWAY_CASING.get();
        }

        public static ItemLike electronTube() {
            return (ItemLike)AllItems.ELECTRON_TUBE.get();
        }

        public static ItemLike precisionMechanism() {
            return (ItemLike)AllItems.PRECISION_MECHANISM.get();
        }

        public static ItemLike copperBlock() {
            return Items.COPPER_BLOCK;
        }

        public static TagKey<Item> brassBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/brass");
        }

        public static TagKey<Item> zincBlock() {
            return AllTags.commonItemTag((String)"storage_blocks/zinc");
        }

        public static TagKey<Item> wheatFlour() {
            return AllTags.commonItemTag((String)"flour/wheat");
        }

        public static ItemLike copperIngot() {
            return Items.COPPER_INGOT;
        }

        public static TagKey<Item> copperSheet() {
            return AllTags.commonItemTag((String)"plates/copper");
        }

        public static TagKey<Item> copperNugget() {
            return AllTags.commonItemTag((String)"nuggets/copper");
        }

        public static TagKey<Item> brassNugget() {
            return AllTags.commonItemTag((String)"nuggets/brass");
        }

        public static TagKey<Item> zincNugget() {
            return AllTags.commonItemTag((String)"nuggets/zinc");
        }

        public static ItemLike copperCasing() {
            return (ItemLike)AllBlocks.COPPER_CASING.get();
        }

        public static ItemLike refinedRadiance() {
            return (ItemLike)AllItems.REFINED_RADIANCE.get();
        }

        public static ItemLike shadowSteel() {
            return (ItemLike)AllItems.SHADOW_STEEL.get();
        }

        public static Ingredient netherite() {
            return Ingredient.of((TagKey)AllTags.commonItemTag((String)"ingots/netherite"));
        }

        public static ItemStack resistor10Ohms() {
            ItemStack stack = TFMGBlocks.RESISTOR.asStack();
            stack.set(TFMGDataComponents.RESISTANCE, (Object)10);
            return stack;
        }

        public static ItemStack coil100Turns() {
            ItemStack stack = TFMGItems.ELECTROMAGNETIC_COIL.asStack();
            stack.set(TFMGDataComponents.COIL_TURNS, (Object)100);
            return stack;
        }

        public static ItemStack turbineBlade() {
            ItemStack stack = TFMGItems.TURBINE_BLADE.asStack();
            CompoundTag keroseneTag = new CompoundTag();
            keroseneTag.putString("kerosene", "forge:kerosene");
            CompoundTag keroseneTagName = new CompoundTag();
            keroseneTagName.putString("kerosene", "Kerosene");
            stack.set(TFMGDataComponents.FUEL_TAGS, (Object)keroseneTag);
            stack.set(TFMGDataComponents.FUELS, (Object)keroseneTagName);
            return stack;
        }
    }

    public static class Marker {
    }
}

