/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class VatRecipeParams
extends ProcessingRecipeParams {
    public static List<String> types = new ArrayList<String>();
    public static MapCodec<VatRecipeParams> CODEC;
    public static StreamCodec<RegistryFriendlyByteBuf, VatRecipeParams> STREAM_CODEC;
    public int min_size;
    public int heat_level;
    public List<String> machines;
    public List<String> allowedVatTypes;

    protected final int getHeatLevel() {
        return this.heat_level;
    }

    protected final int getMinSize() {
        return this.min_size;
    }

    protected final List<String> getMachines() {
        return this.machines;
    }

    protected final List<String> getAllowedVatTypes() {
        return this.allowedVatTypes;
    }

    protected void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        ByteBufCodecs.INT.encode((Object)buffer, (Object)this.min_size);
        ByteBufCodecs.INT.encode((Object)buffer, (Object)this.heat_level);
        CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buffer, this.machines);
        CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buffer, this.allowedVatTypes);
    }

    protected void decode(RegistryFriendlyByteBuf buffer) {
        super.decode(buffer);
        this.min_size = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
        this.heat_level = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
        this.machines = (List)CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buffer);
        this.allowedVatTypes = (List)CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buffer);
    }

    static {
        types.add("tfmg:steel_vat");
        types.add("tfmg:cast_iron_vat");
        types.add("tfmg:firebrick_lined_vat");
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VatRecipeParams.codec(VatRecipeParams::new).forGetter(Function.identity()), (App)Codec.INT.optionalFieldOf("min_size", (Object)0).forGetter(VatRecipeParams::getMinSize), (App)Codec.INT.optionalFieldOf("heat_level", (Object)0).forGetter(VatRecipeParams::getHeatLevel), (App)Codec.STRING.listOf().optionalFieldOf("machines", new ArrayList()).forGetter(VatRecipeParams::getMachines), (App)Codec.STRING.listOf().optionalFieldOf("allowed_vat_types", types).forGetter(VatRecipeParams::getAllowedVatTypes)).apply((Applicative)instance, (params, min_size, heat_level, machines, allowed_vat_types) -> {
            params.machines = machines;
            params.min_size = min_size;
            params.heat_level = heat_level;
            params.allowedVatTypes = allowed_vat_types;
            return params;
        }));
        STREAM_CODEC = VatRecipeParams.streamCodec(VatRecipeParams::new);
    }
}

