/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.drmangotea.tfmg.content.items.weapons.flamethrover.FlamethrowerFuel;
import com.mojang.serialization.Codec;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class TFMGDataComponents {
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"tfmg");
    public static final DataComponentType<CompoundTag> FUELS = TFMGDataComponents.register("fuels", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));
    public static final DataComponentType<CompoundTag> FUEL_TAGS = TFMGDataComponents.register("fuel_tags", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));
    public static final DataComponentType<Integer> SPOOL_AMOUNT = TFMGDataComponents.register("spool_amount", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> COIL_TURNS = TFMGDataComponents.register("coil_turns", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> CONFIGURATION_WRENCH_NUMBER = TFMGDataComponents.register("number", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> LITHIUM_BLADE_TIMER = TFMGDataComponents.register("timer", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<FlamethrowerFuel> FLAMETHROWER = TFMGDataComponents.register("flamethrower", builder -> builder.persistent(FlamethrowerFuel.CODEC).networkSynchronized(FlamethrowerFuel.STREAM_CODEC));
    public static final DataComponentType<String> FLAMETHROWER_FUEL = TFMGDataComponents.register("flamethrower_fuel", builder -> builder.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
    public static final DataComponentType<Integer> ACCUMULATOR_STORAGE = TFMGDataComponents.register("storage", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> RESISTANCE = TFMGDataComponents.register("resistance", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> AMOUNT = TFMGDataComponents.register("amount", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Long> POSITION = TFMGDataComponents.register("position", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DataComponentType<Integer> X_POS = TFMGDataComponents.register("x_pos", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> Y_POS = TFMGDataComponents.register("y_pos", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> Z_POS = TFMGDataComponents.register("z_pos", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));

    private static <T> DataComponentType<T> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        DataComponentType type = ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build();
        DATA_COMPONENTS.register(name, () -> type);
        return type;
    }

    @ApiStatus.Internal
    public static void register(IEventBus modEventBus) {
        DATA_COMPONENTS.register(modEventBus);
    }
}

