/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.event;

import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.neoforge.attachment.SkillTreeProgression;
import com.yesman.epicskills.network.client.ClientBoundReloadSkillTree;
import com.yesman.epicskills.network.client.ClientBoundSyncTreeState;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import yesman.epicfight.api.neoevent.HandleEntityDataEvent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@EventBusSubscriber(modid="epicskills")
public abstract class GameEvents {
    @SubscribeEvent
    public static void epicskills$entityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity().getType() == EntityType.PLAYER) {
            event.getEntity().getData(EpicSkillsAttachmentTypes.ABILITY_POINTS);
            event.getEntity().getData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION);
        }
    }

    @SubscribeEvent
    public static void epicskills$entityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getEntity().getType() == EntityType.PLAYER) {
            AbilityPoints abilityPoints = (AbilityPoints)event.getEntity().getData(EpicSkillsAttachmentTypes.ABILITY_POINTS);
            SkillTreeProgression skilltreeProgression = (SkillTreeProgression)event.getEntity().getData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION);
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entity;
                abilityPoints.markDirty();
                abilityPoints.sendChanges();
                CompoundTag compound = new CompoundTag();
                skilltreeProgression.serializeTo(compound);
                EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundSyncTreeState(compound), (ServerPlayer)serverplayer, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void epicskills$onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            for (ServerPlayer serverPlayer : event.getPlayerList().getPlayers()) {
                serverPlayer.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
                    skillTreeProgression.reload(true);
                    EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundReloadSkillTree(true), (ServerPlayer)serverPlayer, (CustomPacketPayload[])new CustomPacketPayload[0]);
                });
            }
        }
    }

    @SubscribeEvent
    public static void epicskills$playerTickPost(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide() && event.getEntity().tickCount % event.getEntity().getType().updateInterval() == 0) {
            event.getEntity().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints -> abilityPoints.sendChanges());
            event.getEntity().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.tick());
        }
    }

    @SubscribeEvent
    public static void epicskills$playerClone(PlayerEvent.Clone event) {
        boolean copyCaps;
        boolean bl = copyCaps = !event.isWasDeath() || (Boolean)EpicFightGameRules.KEEP_SKILLS.getRuleValue(event.getOriginal().level()) != false;
        if (!copyCaps) {
            return;
        }
        event.getOriginal().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> event.getEntity().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression$2 -> {
            CompoundTag compound = new CompoundTag();
            skillTreeProgression.serializeTo(compound);
            skillTreeProgression$2.deserializeFrom(compound);
        }));
        event.getOriginal().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints -> event.getEntity().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints$2 -> {
            CompoundTag compound = new CompoundTag();
            abilityPoints.serializeTo(compound);
            abilityPoints$2.deserializeFrom(compound);
        }));
    }

    @SubscribeEvent
    public static void epicskills$handleEntityDataEventSave(HandleEntityDataEvent.Save event) {
        event.getEntityPatch().getOriginal().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints -> {
            CompoundTag compound = new CompoundTag();
            abilityPoints.serializeTo(compound);
            event.getCompound().put("abilityPoints", (Tag)compound);
        });
        event.getEntityPatch().getOriginal().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
            CompoundTag compound = new CompoundTag();
            skillTreeProgression.serializeTo(compound);
            event.getCompound().put("skillTreeProgression", (Tag)compound);
        });
    }

    @SubscribeEvent
    public static void epicskills$handleEntityDataEventLoad(HandleEntityDataEvent.Load event) {
        event.getEntityPatch().getOriginal().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoints -> abilityPoints.deserializeFrom(event.getCompound().getCompound("abilityPoints")));
        event.getEntityPatch().getOriginal().getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> skillTreeProgression.deserializeFrom(event.getCompound().getCompound("skillTreeProgression")));
    }

    @SubscribeEvent
    public static void epicskills$lootTableLoad(LootTableLoadEvent event) {
        if (event.getKey().equals(BuiltInLootTables.SIMPLE_DUNGEON) || event.getKey().equals(BuiltInLootTables.UNDERWATER_RUIN_SMALL) || event.getKey().equals(BuiltInLootTables.UNDERWATER_RUIN_BIG) || event.getKey().equals(BuiltInLootTables.ABANDONED_MINESHAFT) || event.getKey().equals(BuiltInLootTables.NETHER_BRIDGE) || event.getKey().equals(BuiltInLootTables.RUINED_PORTAL) || event.getKey().equals(BuiltInLootTables.SHIPWRECK_SUPPLY) || event.getKey().equals(BuiltInLootTables.SHIPWRECK_MAP) || event.getKey().equals(BuiltInLootTables.BASTION_OTHER)) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)10.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).build());
        }
        if (event.getKey().equals(BuiltInLootTables.ANCIENT_CITY) || event.getKey().equals(BuiltInLootTables.END_CITY_TREASURE) || event.getKey().equals(BuiltInLootTables.BASTION_BRIDGE) || event.getKey().equals(BuiltInLootTables.BASTION_HOGLIN_STABLE) || event.getKey().equals(BuiltInLootTables.DESERT_PYRAMID) || event.getKey().equals(BuiltInLootTables.PILLAGER_OUTPOST) || event.getKey().equals(BuiltInLootTables.JUNGLE_TEMPLE_DISPENSER) || event.getKey().equals(BuiltInLootTables.SHIPWRECK_TREASURE) || event.getKey().equals(BuiltInLootTables.STRONGHOLD_CORRIDOR) || event.getKey().equals(BuiltInLootTables.STRONGHOLD_CROSSING)) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).build());
        }
        if (event.getKey().equals(BuiltInLootTables.BURIED_TREASURE) || event.getKey().equals(BuiltInLootTables.JUNGLE_TEMPLE) || event.getKey().equals(BuiltInLootTables.STRONGHOLD_LIBRARY) || event.getKey().equals(BuiltInLootTables.BASTION_TREASURE) || event.getKey().equals(BuiltInLootTables.WOODLAND_MANSION)) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).when(LootItemRandomChanceCondition.randomChance((float)0.75f)).build());
        }
    }
}

