/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network;

import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.neoforge.attachment.SkillTreeProgression;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.network.server.ServerBoundConvertAbilityPointRequest;
import com.yesman.epicskills.network.server.ServerBoundUnlockSkillRequest;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.skilltree.SkillTree;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.mutable.MutableBoolean;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public interface EpicSkillsServerBoundPayloadHandler {
    public static void handleConvertAbilityPointRequest(ServerBoundConvertAbilityPointRequest data, IPayloadContext context) {
        Player player = context.player();
        player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilityPoint -> {
            boolean success = abilityPoint.convertExpToAbilityPoints();
            EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundSetAbilityPoints(success, abilityPoint.getAbilityPoints(), abilityPoint.getRequiredExp()), (ServerPlayer)((ServerPlayer)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public static void handleUnlockSkillRequest(ServerBoundUnlockSkillRequest data, IPayloadContext context) {
        Player player = context.player();
        SkillTreeProgression skillTreeProgression = (SkillTreeProgression)player.getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).orElseThrow(() -> new IllegalStateException("No skill tree progression"));
        AbilityPoints abilityPoints = (AbilityPoints)player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).orElseThrow(() -> new IllegalStateException("No skill tree progression"));
        player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).get(data.skillTree()).ifPresentOrElse(skillTree -> {
            if (skillTreeProgression.canUnlockNode((Holder.Reference<SkillTree>)skillTree, (Skill)data.skill().value(), abilityPoints, true)) {
                skillTreeProgression.unlockNode((Holder.Reference<SkillTree>)skillTree, (Skill)data.skill().value());
                MutableBoolean askSkillChangeLater = new MutableBoolean(false);
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, ServerPlayerPatch.class).ifPresent(playerpatch -> {
                    if (!playerpatch.getPlayerSkills().isEquipping((Skill)data.skill().value())) {
                        SkillContainer container = playerpatch.getPlayerSkills().getFirstEmptyContainer(((Skill)data.skill().value()).getCategory());
                        if (container != null) {
                            if (container.setSkill((Skill)data.skill().value())) {
                                EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)container.createSyncPacketToLocalPlayer(), (ServerPlayer)((ServerPlayer)playerpatch.getOriginal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((CustomPacketPayload)container.createSyncPacketToRemotePlayer(), (Entity)player, (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        } else {
                            askSkillChangeLater.setTrue();
                        }
                    }
                });
                EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundUnlockNode(data.skillTree(), data.skill(), SkillTreeProgression.NodeState.UNLOCKED, false, false, askSkillChangeLater.booleanValue(), true), (ServerPlayer)((ServerPlayer)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            abilityPoints.sendChanges();
        }, () -> EpicSkills.LOGGER.error("No skill tree: " + String.valueOf(SkillTree.SKILL_TREE_REGISTRY_KEY)));
    }
}

