/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;

public class PlayerAbilityPointsCommand {
    private static final SimpleCommandExceptionType EXCEPTION_NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicskills.failed.no_players"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"abilitypoints").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(command -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)command, (String)"target");
            AbilityPoints abilityPoints = player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).orElse(null);
            if (abilityPoints != null) {
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.epicskills.abilitypoints.value.get.success", (Object[])new Object[]{player.getName(), String.valueOf(abilityPoints.getAbilityPoints())}), false);
                return abilityPoints.getAbilityPoints();
            }
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)"commands.epicskills.abilitypoints.value.get.fail"));
            return 0;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(command -> PlayerAbilityPointsCommand.processAbilityPointValueSet((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), "set")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> PlayerAbilityPointsCommand.processAbilityPointValueSet((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), "add")))))).then(Commands.literal((String)"reset_exp_require").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(command -> PlayerAbilityPointsCommand.processExpReset((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"targets"))))));
    }

    private static int processExpReset(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players) throws CommandSyntaxException {
        int done = 0;
        for (ServerPlayer player : players) {
            if (!PlayerAbilityPointsCommand.resetExpRequirement(player)) continue;
            ++done;
        }
        if (done == 0) {
            throw EXCEPTION_NO_PLAYERS_FOUND.create();
        }
        if (done == 1) {
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerAbilityPointsCommand.wrap(Component.translatable((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.single", (Object[])new Object[]{players.iterator().next().getDisplayName()})), true);
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) continue;
                serverplayer.sendSystemMessage((Component)Component.translatable((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.other", (Object[])new Object[]{String.valueOf(done)}));
            }
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerAbilityPointsCommand.wrap(Component.translatable((String)"commands.epicskills.abilitypoints.reset_exp_requirement.success.other", (Object[])new Object[]{String.valueOf(done)})), true);
        }
        return done;
    }

    private static int processAbilityPointValueSet(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players, int value, String operation) throws CommandSyntaxException {
        int done = 0;
        for (ServerPlayer player : players) {
            switch (operation) {
                case "set": {
                    if (!PlayerAbilityPointsCommand.setAbilityPoints(player, value)) break;
                    ++done;
                    break;
                }
                case "add": {
                    if (!PlayerAbilityPointsCommand.addAbilityPoints(player, value)) break;
                    ++done;
                }
            }
        }
        if (done == 0) {
            throw EXCEPTION_NO_PLAYERS_FOUND.create();
        }
        if (done == 1) {
            players.iterator().next().getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilitypoints -> ((CommandSourceStack)command.getSource()).sendSuccess(PlayerAbilityPointsCommand.wrap(Component.translatable((String)"commands.epicskills.abilitypoints.success.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName(), String.valueOf(abilitypoints.getAbilityPoints())})), true));
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) continue;
                serverplayer.sendSystemMessage((Component)Component.translatable((String)"commands.epicskills.abilitypoints.success.other", (Object[])new Object[]{String.valueOf(done)}));
            }
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerAbilityPointsCommand.wrap(Component.translatable((String)"commands.epicskills.abilitypoints.success.other", (Object[])new Object[]{String.valueOf(done)})), true);
        }
        return done;
    }

    private static boolean setAbilityPoints(ServerPlayer player, int value) {
        player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setAbilityPoints(value);
            abilitypoints.markDirty();
        });
        return player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).isPresent();
    }

    private static boolean addAbilityPoints(ServerPlayer player, int value) {
        player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setAbilityPoints(abilitypoints.getAbilityPoints() + value);
            abilitypoints.markDirty();
        });
        return player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).isPresent();
    }

    public static boolean resetExpRequirement(ServerPlayer player) {
        player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).ifPresent(abilitypoints -> {
            abilitypoints.setRequiredExp(7);
            abilitypoints.markDirty();
        });
        return player.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).isPresent();
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }
}

