/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.appliedsoul.common.me.cell;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.AEConfig;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.yxiao233.appliedsoul.common.item.SoulCellItem;
import net.yxiao233.appliedsoul.common.me.cell.SoulCellInventory;
import org.jetbrains.annotations.Nullable;

public class SoulCellHandler
implements ICellHandler {
    public static final SoulCellHandler INSTANCE = new SoulCellHandler();

    private SoulCellHandler() {
    }

    public boolean isCell(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem() instanceof SoulCellItem;
    }

    @Nullable
    public SoulCellInventory getCellInventory(ItemStack itemStack, @Nullable ISaveProvider iSaveProvider) {
        return this.isCell(itemStack) ? new SoulCellInventory((SoulCellItem)itemStack.getItem(), itemStack, iSaveProvider) : null;
    }

    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        SoulCellInventory handler = this.getCellInventory(is, null);
        if (handler != null) {
            lines.add(Tooltips.bytesUsed((long)handler.getUsedBytes(), (long)handler.getTotalBytes()));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack is) {
        SoulCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return Optional.empty();
        }
        List<Object> list = new ArrayList();
        ArrayList upgrades = new ArrayList();
        boolean showAmounts = false;
        long amount = handler.getSoulAmount();
        if (AEConfig.instance().isTooltipShowCellUpgrades() && amount > 0L) {
            showAmounts = true;
            handler.getUpgrades().forEach(upgrades::add);
            list.add(new GenericStack((AEKey)SoulKey.INSTANCE, handler.getSoulAmount()));
        } else {
            list = Collections.emptyList();
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, list, false, showAmounts));
    }
}

