/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.model;

import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class AntlionModel
extends GeoModel<AntlionEntity> {
    public ResourceLocation getModelResource(AntlionEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)("geo/antlion" + this.prefix(animatable) + ".geo.json"));
    }

    public ResourceLocation getTextureResource(AntlionEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)("textures/entity/antlion" + this.prefix(animatable) + (animatable.hasFur() && animatable.getVariant() == 0 ? "_hair" : "") + ".png"));
    }

    public ResourceLocation getAnimationResource(AntlionEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)("animations/antlion" + this.prefix(animatable) + ".animation.json"));
    }

    private String prefix(AntlionEntity animatable) {
        return switch (animatable.getVariant()) {
            case 0 -> "_base";
            case 1 -> "_pupa";
            case 2 -> "_adult";
            default -> "_soldier";
        };
    }

    public void setCustomAnimations(AntlionEntity animatable, long instanceId, AnimationState<AntlionEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (head != null && animatable.getAttackType() == 0 && entityData != null) {
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * 0.5f * ((float)Math.PI / 180));
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }
}

