/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class CorneliusScreen
extends AbstractContainerScreen<CorneliusContainerMenu> {
    private static final ResourceLocation TEX_TOP = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/cornelius_gui_top.png");
    private static final ResourceLocation TEX_BOTTOM = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/cornelius_gui_bottom.png");
    private static final int ANIM_TICKS = 8;
    private static final int DEAL_INTERVAL_TICKS = 6;
    private int dealDelay = 0;
    private final ArrayDeque<Boolean> dealQueue = new ArrayDeque();
    private int resultTicks = 0;
    private final List<FrogCard> playerCards = new ArrayList<FrogCard>();
    private final List<FrogCard> dealerCards = new ArrayList<FrogCard>();
    private FrogCard hoveredCard = null;
    private static final float LERP_DELTA = 0.235f;
    private static final int END_GAME_TIME = 30;
    private static final int CARD_W = 24;
    private static final int CARD_H = 36;
    private static final int V_BACK = 144;
    private static final int PLAYER_Y = 14;
    private static final int DEALER_Y = -40;
    private static final int START_Y = -50;
    private static final int SPACING_PLAYER = -10;
    private static final int SPACING_DEALER = -14;
    private static final int MARGIN_PLAYER = 63;
    private static final int MARGIN_DEALER = 58;
    private static final float HOVER_SCALE = 1.25f;
    private static final float HOVER_W = 30.0f;
    private static final float HOVER_H = 45.0f;
    private Button btnHit;
    private Button btnStand;
    private boolean hitButtonPressed = false;
    private boolean standButtonPressed = false;
    private Phase phase = Phase.WAITING_PLAY;
    private Result result;
    private Result pendingResult = null;

    public CorneliusScreen(CorneliusContainerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    private int generalMarginLeft() {
        return (this.width - this.imageWidth) / 2;
    }

    private int generalMarginTop() {
        return (this.height - this.imageHeight) / 2;
    }

    private FrogCard newCard2Player() {
        return new FrogCard((float)(this.width - 24) / 2.0f, -50.0f, this.generalMarginLeft() + 63 + this.playerCards.size() * 14, this.generalMarginTop() + 14 + 17, new Random().nextInt(13) + 1, true);
    }

    private FrogCard newCard2Crupier() {
        int idx = this.dealerCards.size();
        float targetX = this.generalMarginLeft() + 58 + idx * 10;
        if (idx >= 1) {
            targetX += 10.0f;
        }
        return new FrogCard((float)(this.width - 24) / 2.0f, -50.0f, targetX, this.generalMarginTop() + -40, new Random().nextInt(13) + 1, idx != 0);
    }

    protected void init() {
        super.init();
        this.btnHit = this.addRenderableWidget(new ImageButtonWrapper(this.generalMarginLeft() + 80, this.generalMarginTop() + 14 + 100, 43, 29, 0, 227, 256, 256, TEX_TOP, b -> {
            int c = 0;
            for (int i = 3; i <= 5; ++i) {
                if (!((Slot)((CorneliusContainerMenu)this.menu).slots.get(i)).getItem().isEmpty()) continue;
                ++c;
            }
            if (c == 3) {
                return;
            }
            if (this.phase == Phase.WAITING_PLAY) {
                this.startGame();
            } else if (this.phase == Phase.PLAYER_TURN) {
                this.onHit();
            }
        }){

            public void onPress() {
                super.onPress();
                if (CorneliusScreen.this.phase != Phase.WAITING_PLAY) {
                    CorneliusScreen.this.hitButtonPressed = true;
                }
            }

            @Override
            public void renderWidget(@NotNull GuiGraphics g, int mx, int my, float pt) {
                if (CorneliusScreen.this.hitButtonPressed) {
                    g.blit(TEX_TOP, this.getX(), this.getY(), 0, 227, 43, 29);
                }
            }
        });
        this.btnStand = this.addRenderableWidget(new ImageButtonWrapper(this.generalMarginLeft() + 119, this.generalMarginTop() + 14 + 100, 43, 29, 0, 227, 256, 256, TEX_TOP, b -> this.onStand()){

            public void onPress() {
                super.onPress();
                if (CorneliusScreen.this.phase != Phase.WAITING_PLAY) {
                    CorneliusScreen.this.standButtonPressed = true;
                }
            }

            @Override
            public void renderWidget(@NotNull GuiGraphics g, int mx, int my, float pt) {
                if (CorneliusScreen.this.standButtonPressed) {
                    g.blit(TEX_TOP, this.getX(), this.getY(), 211, 227, 46, 29);
                }
            }
        });
    }

    private HandValue fullHandValue(List<FrogCard> cards) {
        int total = 0;
        int aces = 0;
        for (FrogCard card : cards) {
            int v = card.value;
            if (v == 1) {
                total += 11;
                ++aces;
                continue;
            }
            total += Math.min(v, 10);
        }
        while (total > 21 && aces > 0) {
            total -= 10;
            --aces;
        }
        return new HandValue(total, aces > 0);
    }

    public void resize(@NotNull Minecraft mc, int width, int height) {
        int oldLeft = this.generalMarginLeft();
        int oldTop = this.generalMarginTop();
        super.resize(mc, width, height);
        CorneliusScreen.shiftCards(this.playerCards, this.generalMarginLeft() - oldLeft, this.generalMarginTop() - oldTop);
        CorneliusScreen.shiftCards(this.dealerCards, this.generalMarginLeft() - oldLeft, this.generalMarginTop() - oldTop);
    }

    private static void shiftCards(List<FrogCard> list, int dx, int dy) {
        for (FrogCard card : list) {
            card.x += (float)dx;
            card.prevX += (float)dx;
            card.targetX += (float)dx;
            card.y += (float)dy;
            card.prevY += (float)dy;
            card.targetY += (float)dy;
        }
    }

    private void startGame() {
        this.phase = Phase.DEALING;
        this.playerCards.clear();
        this.dealerCards.clear();
        this.dealQueue.clear();
        this.dealQueue.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)));
        this.dealDelay = 0;
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode != null) {
            mc.gameMode.handleInventoryButtonClick(((CorneliusContainerMenu)this.menu).containerId, 0);
        }
    }

    private void onHit() {
        if (this.phase != Phase.PLAYER_TURN) {
            return;
        }
        this.dealQueue.add(true);
        this.btnHit.active = false;
        this.btnStand.active = false;
        this.phase = Phase.DEALING;
        this.dealDelay = 0;
    }

    private void onStand() {
        if (this.phase != Phase.PLAYER_TURN) {
            return;
        }
        if (!this.dealerCards.isEmpty()) {
            this.dealerCards.get(0).startFlip();
        }
        this.phase = Phase.DEALER_TURN;
        this.btnHit.visible = false;
        this.btnStand.visible = true;
        this.dealDelay = 6;
        this.standButtonPressed = false;
    }

    protected void containerTick() {
        super.containerTick();
        switch (this.phase.ordinal()) {
            case 1: {
                this.tickCards();
                if (this.dealDelay > 0) {
                    --this.dealDelay;
                }
                if (this.dealDelay == 0 && !this.dealQueue.isEmpty()) {
                    this.spawnNextCard(this.dealQueue.poll());
                    this.dealDelay = 6;
                }
                if (!this.dealQueue.isEmpty() || !this.allArrived()) break;
                this.finishDealing();
                break;
            }
            case 2: {
                if (this.handValue(this.playerCards).total == 21) {
                    this.showResult(Result.BLACKJACK);
                }
                if (this.handValue(this.playerCards).total > 21) {
                    this.showResult(Result.LOSE);
                }
                if (this.handValue(this.dealerCards).total > 21) {
                    this.showResult(Result.WIN);
                }
                if (this.handValue(this.dealerCards).total != 21) break;
                this.showResult(Result.LOSE);
                break;
            }
            case 3: {
                this.tickCards();
                if (this.dealDelay > 0) {
                    --this.dealDelay;
                    break;
                }
                if (this.fullHandValue(this.dealerCards).total < 17 || this.fullHandValue(this.dealerCards).total == 17 && this.fullHandValue(this.dealerCards).soft) {
                    this.spawnNextCard(false);
                    this.dealDelay = 6;
                    break;
                }
                if (!this.allArrived() || !this.noCardIsFlipping()) break;
                this.evaluateGame();
                break;
            }
            case 4: {
                if (++this.resultTicks < 30) break;
                this.resetToWaitingPlay();
                break;
            }
        }
        if (this.pendingResult != null && this.allArrived() && this.noCardIsFlipping()) {
            this.showResult(this.pendingResult);
            this.pendingResult = null;
        }
    }

    private boolean noCardIsFlipping() {
        return Stream.concat(this.playerCards.stream(), this.dealerCards.stream()).noneMatch(card -> card.flipping);
    }

    private boolean tickCards() {
        boolean all = true;
        for (FrogCard card : this.playerCards) {
            if (card.tick(0.235f)) continue;
            all = false;
        }
        for (FrogCard card : this.dealerCards) {
            if (card.tick(0.235f)) continue;
            all = false;
        }
        return all;
    }

    private void spawnNextCard(boolean toPlayer) {
        if (toPlayer) {
            this.playerCards.add(this.newCard2Player());
        } else {
            this.dealerCards.add(this.newCard2Crupier());
        }
        if (this.minecraft != null) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CompanionsSounds.FLIP_CARD.get(), (float)1.0f));
        }
    }

    private boolean allArrived() {
        for (FrogCard card : this.playerCards) {
            if (card.arrived) continue;
            return false;
        }
        for (FrogCard card : this.dealerCards) {
            if (card.arrived) continue;
            return false;
        }
        return true;
    }

    private void finishDealing() {
        if (this.phase != Phase.DEALING) {
            return;
        }
        if (this.playerCards.size() == 2 && this.handValue(this.playerCards).total == 21) {
            this.showResult(Result.BLACKJACK);
            return;
        }
        if (this.dealerCards.size() == 2 && this.handValue(this.dealerCards).total == 21) {
            this.showResult(Result.LOSE);
            return;
        }
        this.phase = Phase.PLAYER_TURN;
        this.btnStand.visible = true;
        this.btnHit.visible = true;
        this.btnStand.active = true;
        this.btnHit.active = true;
        this.standButtonPressed = false;
        this.hitButtonPressed = false;
    }

    private void evaluateGame() {
        int player = this.handValue(this.playerCards).total;
        int frog = this.handValue(this.dealerCards).total;
        this.pendingResult = player > 21 ? Result.LOSE : (frog > 21 ? Result.WIN : (player == frog ? Result.TIE : (player > frog ? Result.WIN : Result.LOSE)));
    }

    private void showResult(Result result) {
        this.result = result;
        this.phase = Phase.SHOW_RESULT;
        this.resultTicks = 0;
        this.btnStand.visible = false;
        this.btnHit.visible = false;
        int action = switch (result.ordinal()) {
            case 0 -> 4;
            case 3 -> 5;
            case 2 -> 3;
            default -> 2;
        };
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode != null) {
            mc.gameMode.handleInventoryButtonClick(((CorneliusContainerMenu)this.menu).containerId, action);
        }
    }

    private void resetToWaitingPlay() {
        this.phase = Phase.WAITING_PLAY;
        this.playerCards.clear();
        this.dealerCards.clear();
        this.dealQueue.clear();
        this.dealDelay = 0;
        this.btnHit.visible = true;
        this.btnHit.active = true;
        this.btnStand.visible = false;
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode != null) {
            mc.gameMode.handleInventoryButtonClick(((CorneliusContainerMenu)this.menu).containerId, 1);
        }
    }

    private void renderResultOverlay(GuiGraphics g) {
        int w;
        int v;
        int u;
        if (this.phase != Phase.SHOW_RESULT) {
            return;
        }
        int h = switch (this.result.ordinal()) {
            case 0 -> {
                u = 41;
                v = 83;
                w = 69;
                yield 44;
            }
            case 2 -> {
                u = 40;
                v = 135;
                w = 55;
                yield 29;
            }
            case 3 -> {
                u = 113;
                v = 136;
                w = 91;
                yield 61;
            }
            default -> {
                u = 123;
                v = 83;
                w = 78;
                yield 42;
            }
        };
        float bScale = this.resultTicks < 8 ? (float)this.resultTicks / 8.0f : (this.resultTicks > 22 ? (float)(30 - this.resultTicks) / 8.0f : 1.0f);
        bScale = Mth.clamp((float)bScale, (float)0.0f, (float)1.0f);
        float scale = Util.smoothStep(bScale);
        g.pose().pushPose();
        g.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f - 70.0f, 0.0f);
        g.pose().scale(scale * 1.25f, scale * 1.25f, 1.0f);
        g.pose().translate((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEX_TOP);
        g.blit(TEX_TOP, 0, 0, u, v, w, h);
        g.pose().popPose();
    }

    private void updateHoveredCard(int mx, int my, float pt) {
        if (this.hoveredCard != null) {
            float cx = Mth.lerp((float)pt, (float)this.hoveredCard.prevX, (float)this.hoveredCard.x) + 12.0f;
            float cy = Mth.lerp((float)pt, (float)this.hoveredCard.prevY, (float)this.hoveredCard.y) + 18.0f;
            if ((float)mx >= cx - 15.0f && (float)mx < cx + 15.0f && (float)my >= cy - 22.5f && (float)my < cy + 22.5f) {
                return;
            }
            this.hoveredCard = null;
        }
        for (int i = this.playerCards.size() - 1; i >= 0; --i) {
            FrogCard card = this.playerCards.get(i);
            if (!card.faceUp) continue;
            float dx = Mth.lerp((float)pt, (float)card.prevX, (float)card.x);
            float dy = Mth.lerp((float)pt, (float)card.prevY, (float)card.y);
            if (!((float)mx >= dx) || !((float)mx < dx + 24.0f) || !((float)my >= dy) || !((float)my < dy + 36.0f)) continue;
            this.hoveredCard = card;
            break;
        }
    }

    private void renderCards(GuiGraphics g, float pt, int mx, int my) {
        for (FrogCard card : this.dealerCards) {
            this.renderCard(g, card, pt);
        }
        if (this.hoveredCard == null) {
            for (FrogCard card : this.playerCards) {
                this.renderCard(g, card, pt);
            }
        } else {
            int i;
            int idx = this.playerCards.indexOf(this.hoveredCard);
            for (i = 0; i < idx; ++i) {
                this.renderCard(g, this.playerCards.get(i), pt);
            }
            this.renderHoveredCard(g, pt, mx, my);
            for (i = idx + 1; i < this.playerCards.size(); ++i) {
                this.renderCard(g, this.playerCards.get(i), pt);
            }
        }
    }

    private void renderHoveredCard(GuiGraphics g, float pt, int mx, int my) {
        if (this.hoveredCard == null) {
            return;
        }
        float dx = Mth.lerp((float)pt, (float)this.hoveredCard.prevX, (float)this.hoveredCard.x);
        float dy = Mth.lerp((float)pt, (float)this.hoveredCard.prevY, (float)this.hoveredCard.y);
        float centerX = dx + 12.0f;
        float centerY = dy + 18.0f;
        float tilt = 25.0f;
        float tiltY = ((float)mx - centerX) / 12.0f * tilt;
        float tiltX = -((float)my - centerY) / 18.0f * tilt;
        g.pose().pushPose();
        g.pose().translate(centerX, centerY, 10.0f);
        g.pose().scale(1.25f, 1.25f, 1.0f);
        g.pose().translate(-centerX, -centerY, 0.0f);
        this.renderCardAt(g, this.hoveredCard, (int)dx, (int)dy, tiltX, tiltY);
        g.pose().popPose();
    }

    protected void renderBg(GuiGraphics g, float pt, int mx, int my) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEX_TOP);
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)TEX_BOTTOM);
        g.blit(TEX_TOP, (this.width - 207) / 2, this.generalMarginTop() - 50, 45, 44, 208, 20);
        g.blit(TEX_BOTTOM, (this.width - 207) / 2, this.generalMarginTop() - 30, 45, 0, 208, 256);
    }

    private void renderCard(GuiGraphics g, FrogCard c, float pt) {
        this.renderCardAt(g, c, (int)Mth.lerp((float)pt, (float)c.prevX, (float)c.x), (int)Mth.lerp((float)pt, (float)c.prevY, (float)c.y), 0.0f, 0.0f);
    }

    private void renderCardAt(GuiGraphics g, FrogCard card, int dx, int dy, float tiltX, float tiltY) {
        RenderSystem.disableCull();
        g.pose().pushPose();
        g.pose().translate((float)dx + 12.0f, (float)dy + 18.0f, 40.0f);
        g.pose().mulPose(Axis.XP.rotationDegrees(tiltX));
        g.pose().mulPose(Axis.YP.rotationDegrees(tiltY));
        g.pose().mulPose(Axis.YP.rotationDegrees(card.getFlipAngle()));
        g.pose().translate(-((float)dx + 12.0f), -((float)dy + 18.0f), 0.0f);
        if (card.faceUp) {
            int u = card.value <= 10 ? (card.value - 1) * 24 : 0;
            int v = card.value <= 10 ? 0 : (card.value - 10) * 36;
            g.blit(TEX_TOP, dx, dy, u, v, 24, 36);
        } else {
            g.blit(TEX_TOP, dx, dy, 0, 144, 24, 36);
        }
        g.pose().popPose();
        RenderSystem.enableCull();
    }

    public void render(@NotNull GuiGraphics g, int mx, int my, float pt) {
        this.updateHoveredCard(mx, my, pt);
        this.renderBackground(g, mx, my, pt);
        super.render(g, mx, my, pt);
        RenderSystem.disableDepthTest();
        this.renderCards(g, pt, mx, my);
        this.renderHoveredCard(g, pt, mx, my);
        this.renderResultOverlay(g);
        RenderSystem.enableDepthTest();
        this.renderTooltip(g, mx, my);
    }

    protected void renderLabels(@NotNull GuiGraphics g, int mx, int my) {
        if (this.handValue(this.playerCards).total != 0) {
            g.drawString(this.font, String.valueOf(this.handValue(this.playerCards).total), 46, 57, 12826189);
        }
        if (this.handValue(this.dealerCards).total != 0) {
            g.drawString(this.font, String.valueOf(this.handValue(this.dealerCards).total), 34, -42, 12826189);
        }
    }

    @NotNull
    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(@NotNull T w) {
        return (T)super.addRenderableWidget(w);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue() || pKeyCode == 256) && this.phase != Phase.WAITING_PLAY) {
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        if (this.phase == Phase.WAITING_PLAY) {
            super.onClose();
        }
    }

    private HandValue handValue(List<FrogCard> cards) {
        int total = 0;
        int aces = 0;
        for (FrogCard c : cards) {
            if (!c.faceUp) continue;
            int v = c.value;
            if (v == 1) {
                total += 11;
                ++aces;
                continue;
            }
            total += Math.min(v, 10);
        }
        while (total > 21 && aces > 0) {
            total -= 10;
            --aces;
        }
        return new HandValue(total, aces > 0);
    }

    private static class FrogCard {
        public float x;
        public float y;
        public float prevX;
        public float prevY;
        public float targetX;
        public float targetY;
        public final int value;
        public boolean faceUp;
        public boolean arrived = false;
        public boolean flipping = false;
        public int flipTick = 0;
        public static final int FLIP_TOTAL = 20;

        public FrogCard(float startX, float startY, float targetX, float targetY, int value, boolean faceUp) {
            this.x = startX;
            this.y = startY;
            this.prevX = startX;
            this.prevY = startY;
            this.targetX = targetX;
            this.targetY = targetY;
            this.value = value;
            this.faceUp = faceUp;
        }

        public void startFlip() {
            if (!this.faceUp && !this.flipping) {
                this.flipping = true;
                this.flipTick = 0;
            }
        }

        public boolean tick(float s) {
            if (this.flipping) {
                ++this.flipTick;
                if ((float)this.flipTick == 10.0f) {
                    this.faceUp = true;
                }
                if (this.flipTick >= 20) {
                    this.flipping = false;
                }
            }
            if (this.arrived) {
                this.prevX = this.x;
                this.prevY = this.y;
                return true;
            }
            this.prevX = this.x;
            this.prevY = this.y;
            this.x += (this.targetX - this.x) * s;
            this.y += (this.targetY - this.y) * s;
            if (Math.abs(this.x - this.targetX) < 0.5f && Math.abs(this.y - this.targetY) < 0.5f) {
                this.x = this.targetX;
                this.y = this.targetY;
                this.prevX = this.targetX;
                this.prevY = this.targetY;
                this.arrived = true;
            }
            return this.arrived;
        }

        public float getFlipAngle() {
            if (!this.flipping) {
                return 0.0f;
            }
            float half = 10.0f;
            if ((float)this.flipTick <= half) {
                return 90.0f * ((float)this.flipTick / half);
            }
            return 90.0f * (1.0f - ((float)this.flipTick - half) / half);
        }
    }

    private static enum Phase {
        WAITING_PLAY,
        DEALING,
        PLAYER_TURN,
        DEALER_TURN,
        SHOW_RESULT;

    }

    private static enum Result {
        WIN,
        LOSE,
        TIE,
        BLACKJACK;

    }

    private record HandValue(int total, boolean soft) {
    }

    public static class ImageButtonWrapper
    extends Button {
        private final ResourceLocation atlas;
        private final int u;
        private final int v;
        private final int texWidth;
        private final int texHeight;

        public ImageButtonWrapper(int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, ResourceLocation atlas, Button.OnPress onPress) {
            super(x, y, width, height, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.atlas = atlas;
        }

        public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
            gui.blit(this.atlas, this.getX(), this.getY(), (float)this.u, (float)this.v, this.width, this.height, this.texWidth, this.texHeight);
        }
    }
}

