/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class StaticElectricConnectionLayer<T extends AbstractTeslaBlockEntity>
extends GeoRenderLayer<T> {
    private final ResourceLocation texture;
    private final int totalFrames;
    private final int ticksPerFrame;

    public StaticElectricConnectionLayer(GeoRenderer<T> renderer, ResourceLocation texture, int totalFrames, int ticksPerFrame) {
        super(renderer);
        this.texture = texture;
        this.totalFrames = totalFrames;
        this.ticksPerFrame = ticksPerFrame;
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!((AbstractTeslaBlockEntity)((Object)animatable)).isActive()) {
            return;
        }
        int frame = this.calculateCurrentFrame(animatable);
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(((AbstractTeslaBlockEntity)((Object)animatable)).asConnectionNode())) {
            AbstractTeslaBlockEntity be;
            if (node == null) continue;
            if (node.isEntity()) {
                Entity entity = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                Vec3 offset = new Vec3(0.0, 1.25, 0.0);
                Vec3 dir = livingEntity.position().subtract(animatable.getBlockPos().getCenter()).add(0.0, (double)livingEntity.getBbHeight() * 1.1, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
                continue;
            }
            if (!node.isBlock() || !((be = TeslaConnectionManager.getInstance().getBlockEntity(node)) instanceof VoltaicPillarBlockEntity)) continue;
            Vec3 offset = ((AbstractTeslaBlockEntity)((Object)animatable)).electricalChargeOriginOffset();
            Vec3 blockPos = be.getBlockPos().getCenter();
            Vec3 blockPosVec = new Vec3(blockPos.x, blockPos.y, blockPos.z);
            Vec3 dir = blockPosVec.subtract(animatable.getBlockPos().getCenter()).add(be.electricalChargeEndOffset());
            this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
        }
    }

    private int calculateCurrentFrame(T animatable) {
        if (animatable.getLevel() != null) {
            long elapsed = animatable.getLevel().getGameTime() - (long)((AbstractTeslaBlockEntity)((Object)animatable)).getAnimationStartTick();
            return (int)(elapsed / (long)this.ticksPerFrame) % this.totalFrames + 1;
        }
        return 0;
    }

    private void renderConnection(MultiBufferSource bufferSource, PoseStack poseStack, Vec3 p0, Vec3 p1, int frame, int light) {
        int[] indices;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(AutoGlowingTexture.getRenderType((ResourceLocation)this.texture));
        Matrix4f positionMatrix = poseStack.last().pose();
        Matrix3f normalMatrix = poseStack.last().normal();
        float x0 = (float)p0.x;
        float y0 = (float)p0.y;
        float z0 = (float)p0.z;
        float x1 = (float)p1.x;
        float y1 = (float)p1.y;
        float z1 = (float)p1.z;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        if (dx == 0.0f) {
            dx = 0.001f;
        }
        float dHorizontal = Mth.sqrt((float)(dx * dx + dz * dz));
        float length = Mth.sqrt((float)(dHorizontal * dHorizontal + dy * dy));
        float offset = 0.5f;
        float yOffset = offset * (dHorizontal / length);
        float xOffset = offset * (dy / length) * (dx / dHorizontal);
        float zOffset = offset * (dy / length) * (dz / dHorizontal);
        float frameSize = 1.0f / (float)this.totalFrames;
        float v0 = (float)frame * frameSize;
        float v1 = v0 + frameSize;
        VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
        for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
            this.produceVertex(vertexConsumer, positionMatrix, poseStack, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
        }
    }

    private void produceVertex(VertexConsumer vertexConsumer, Matrix4f positionMatrix, PoseStack poseStack, int light, float x, float y, float z, float textureU, float textureV) {
        vertexConsumer.addVertex(positionMatrix, x, y, z).setColor(255, 255, 255, 255).setUv(textureU, textureV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    private record VertexCoordinates(float x, float y, float z, float u, float v) {
    }
}

