/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.model;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class SoulMageBookModel
extends GeoModel<SoulMageBookEntity> {
    private float currentBookYaw = 0.0f;

    public ResourceLocation getModelResource(SoulMageBookEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"geo/soul_mage_book.geo.json");
    }

    public ResourceLocation getTextureResource(SoulMageBookEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/soul_mage_book.png");
    }

    public void setCustomAnimations(SoulMageBookEntity animatable, long instanceId, AnimationState<SoulMageBookEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        GeoBone mainB = this.getAnimationProcessor().getBone("book2");
        if (mainB == null) {
            return;
        }
        float targetYaw = 0.0f;
        Entity entity = animatable.getOwner();
        if (entity instanceof SoulMageEntity) {
            SoulMageEntity mage = (SoulMageEntity)entity;
            Vec3 diff = mage.position().subtract(animatable.position());
            targetYaw = (float)(Math.atan2(diff.z, diff.x) * 57.29577951308232) - 90.0f;
            float oscillation = (float)(Math.sin((double)animatable.tickCount * 0.05) * 5.0);
            targetYaw += oscillation;
        }
        float angleDiff = this.wrapDegrees(targetYaw - this.currentBookYaw);
        this.currentBookYaw += angleDiff * 0.005f;
        mainB.setRotY((float)Math.toRadians(this.currentBookYaw));
    }

    private float wrapDegrees(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public ResourceLocation getAnimationResource(SoulMageBookEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"animations/soul_mage_book.animation.json");
    }
}

