/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.FireRayPieceModel;
import dev.xylonity.companions.common.entity.projectile.FireRayPieceProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FireRayPieceRenderer
extends GeoEntityRenderer<FireRayPieceProjectile> {
    public FireRayPieceRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FireRayPieceModel());
    }

    protected void applyRotations(FireRayPieceProjectile animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        float yaw = Mth.rotLerp((float)partialTick, (float)animatable.getPieceYaw(), (float)animatable.getPieceYaw());
        float pitch = Mth.lerp((float)partialTick, (float)animatable.getPiecePitch(), (float)animatable.getPiecePitch());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
    }

    public RenderType getRenderType(FireRayPieceProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }
}

