/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.projectile.model.FloorCakeCreamModel;
import dev.xylonity.companions.common.entity.projectile.FloorCakeCreamProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FloorCakeCreamRenderer
extends GeoEntityRenderer<FloorCakeCreamProjectile> {
    public FloorCakeCreamRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FloorCakeCreamModel());
    }

    public RenderType getRenderType(FloorCakeCreamProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }

    public void actuallyRender(PoseStack poseStack, FloorCakeCreamProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(animatable.getSize(), animatable.getSize(), animatable.getSize());
        int a = Math.round(this.alpha(animatable) * 255.0f);
        int rgb = 0xFFFFFF;
        int colour2 = a << 24 | rgb;
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, this.getPackedOverlay((Entity)animatable, 0.0f, partialTick), colour2);
    }

    private float alpha(FloorCakeCreamProjectile entity) {
        int fadeIn = 10;
        int fadeOut = entity.getLifetime() - 10;
        if (entity.tickCount <= fadeIn) {
            return (float)entity.tickCount / (float)fadeIn;
        }
        if (entity.tickCount >= fadeOut) {
            float fadeOutProgress = (float)(entity.tickCount - fadeOut) / (float)(entity.getLifetime() - fadeOut);
            return 1.0f - fadeOutProgress;
        }
        return 1.0f;
    }
}

