/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.projectile.model.StoneSpikeModel;
import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class StoneSpikeRenderer
extends GeoEntityRenderer<StoneSpikeProjectile> {
    public StoneSpikeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new StoneSpikeModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull StoneSpikeProjectile animatable) {
        int l = animatable.getLifetime();
        int remaining = l - animatable.tickCount;
        return switch (remaining) {
            case 11, 12 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike1.png");
            case 9, 10 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike2.png");
            case 7, 8 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike3.png");
            case 5, 6 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike4.png");
            case 3, 4 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike5.png");
            case 1, 2 -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike6.png");
            default -> ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/stone_spike0.png");
        };
    }

    public RenderType getRenderType(StoneSpikeProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void actuallyRender(PoseStack poseStack, StoneSpikeProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(1.3f, 1.3f, 1.3f);
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

