/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RespawnTotemBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_LOWER_N = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)17.0, (double)12.0), Block.box((double)3.0, (double)17.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_UPPER_N = Stream.of(Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.box((double)3.0, (double)-12.0, (double)4.0, (double)13.0, (double)1.0, (double)12.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_UPPER_E = Stream.of(Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.box((double)4.0, (double)-12.0, (double)3.0, (double)12.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_LOWER_E = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)17.0, (double)13.0), Block.box((double)3.0, (double)17.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public RespawnTotemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public long getSeed(@NotNull BlockState pState, @NotNull BlockPos pPos) {
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? pPos.asLong() : pPos.below().asLong();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction d = (Direction)pState.getValue((Property)FACING);
        if (d == Direction.NORTH || d == Direction.SOUTH) {
            return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_N : SHAPE_UPPER_N;
        }
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_E : SHAPE_UPPER_E;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(pContext)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public boolean canSurvive(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return pPos.getY() < pLevel.getMaxBuildHeight() - 1;
        }
        BlockState belowState = pLevel.getBlockState(pPos.below());
        return belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand hand, BlockHitResult hitResult) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        Item item = stack.getItem();
        if (item != CompanionsItems.RELIC_GOLD.get() && item != CompanionsItems.OLD_CLOTH.get() && item != Items.NETHER_STAR) {
            return ItemInteractionResult.FAIL;
        }
        BlockPos lowerPos = pState.getValue(HALF) == DoubleBlockHalf.LOWER ? pPos : pPos.below();
        pLevel.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
        pLevel.setBlock(lowerPos.above(), Blocks.AIR.defaultBlockState(), 35);
        LivingEntity entity = null;
        if (item == CompanionsItems.RELIC_GOLD.get()) {
            entity = (LivingEntity)CompanionsEntities.MANKH.get().create(pLevel);
        } else if (item == CompanionsItems.OLD_CLOTH.get()) {
            entity = (LivingEntity)CompanionsEntities.CLOAK.get().create(pLevel);
        } else if (item == Items.NETHER_STAR) {
            entity = (LivingEntity)CompanionsEntities.SACRED_PONTIFF.get().create(pLevel);
        }
        if (entity != null) {
            entity.moveTo((double)lowerPos.getX() + 0.5, (double)lowerPos.getY(), (double)lowerPos.getZ() + 0.5, pLevel.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof CompanionEntity) {
                CompanionEntity companionEntity = (CompanionEntity)entity;
                companionEntity.tameInteraction(pPlayer);
            }
            stack.shrink(1);
            double dx = pPlayer.getX() - (double)pPos.getX();
            double dy = pPlayer.getY() + (double)pPlayer.getEyeHeight() - (double)((float)pPos.getY() + entity.getEyeHeight());
            double dz = pPlayer.getZ() - (double)pPos.getZ();
            float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            entity.setYRot(yaw);
            entity.yBodyRot = yaw;
            entity.yBodyRotO = yaw;
            entity.yHeadRot = yaw;
            entity.yHeadRotO = yaw;
            entity.setXRot(pitch);
            entity.xRotO = pitch;
            pLevel.addFreshEntity((Entity)entity);
        }
        for (int i = 0; i < 20; ++i) {
            double dx = (pLevel.random.nextDouble() - 0.5) * 1.25;
            double dy = (pLevel.random.nextDouble() - 0.5) * 1.25;
            double dz = (pLevel.random.nextDouble() - 0.5) * 1.25;
            if (!(pLevel instanceof ServerLevel)) continue;
            ServerLevel level = (ServerLevel)pLevel;
            if (level.random.nextFloat() < 0.35f) {
                level.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pPos.getX() + 0.5, (double)pPos.getY() + Math.random() * 2.0, (double)pPos.getZ() + 0.5, 1, dx, dy, dz, 0.1);
            }
            if (!(level.random.nextFloat() < 0.65f)) continue;
            level.sendParticles((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), (double)pPos.getX() + 0.5, (double)pPos.getY() + Math.random() * 2.0, (double)pPos.getZ() + 0.5, 1, dx, dy, dz, 0.1);
        }
        pLevel.playSound(null, lowerPos, SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, hand, hitResult);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)pState.getValue(HALF);
        if (pDirection.getAxis() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && pDirection == Direction.UP) {
                return pNeighborState.is((Block)this) && pNeighborState.getValue(HALF) == DoubleBlockHalf.UPPER ? pState : Blocks.AIR.defaultBlockState();
            }
            if (half == DoubleBlockHalf.UPPER && pDirection == Direction.DOWN) {
                return pNeighborState.is((Block)this) && pNeighborState.getValue(HALF) == DoubleBlockHalf.LOWER ? pState : Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public BlockState playerWillDestroy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.isClientSide) {
            if (pPlayer.isCreative()) {
                RespawnTotemBlock.preventCreativeTabDestroy(pLevel, pPos, pState, pPlayer);
            } else {
                BlockPos oPos = pState.getValue(HALF) == DoubleBlockHalf.LOWER ? pPos.above() : pPos.below();
                BlockState oState = pLevel.getBlockState(oPos);
                if (oState.is((Block)this)) {
                    pLevel.setBlock(oPos, Blocks.AIR.defaultBlockState(), 35);
                    pLevel.levelEvent(pPlayer, 2001, oPos, Block.getId((BlockState)oState));
                }
                RespawnTotemBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public static void preventCreativeTabDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (pState.getValue(HALF) == DoubleBlockHalf.UPPER && (lowerState = pLevel.getBlockState(lowerPos = pPos.below())).is(pState.getBlock()) && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
            pLevel.levelEvent(pPlayer, 2001, lowerPos, Block.getId((BlockState)lowerState));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT, HALF});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? CompanionsBlockEntities.RESPAWN_TOTEM.get().create(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER && pBlockEntityType == CompanionsBlockEntities.RESPAWN_TOTEM.get() ? RespawnTotemBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity getMultiblockBlockEntity(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return level.getBlockEntity(pos);
        }
        BlockPos lowerPos = pos.below();
        BlockState lowerState = level.getBlockState(lowerPos);
        if (lowerState.is((Block)this) && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return level.getBlockEntity(lowerPos);
        }
        return null;
    }

    public void updateLitState(Level level, BlockPos pos, BlockState state, boolean lit) {
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos lowerPos = pos.below();
            BlockState lowerState = level.getBlockState(lowerPos);
            if (lowerState.is((Block)this)) {
                level.setBlock(lowerPos, (BlockState)lowerState.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            }
        } else {
            BlockPos upperPos = pos.above();
            BlockState upperState = level.getBlockState(upperPos);
            if (upperState.is((Block)this)) {
                level.setBlock(upperPos, (BlockState)upperState.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            }
        }
    }
}

