/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShadeSwordAltarBlockEntity
extends AbstractShadeAltarBlockEntity {
    private int tickCount = 0;
    private boolean shouldSpawnParticleExplosion = false;

    public ShadeSwordAltarBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.SHADE_SWORD_ALTAR.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (F instanceof ShadeSwordAltarBlockEntity) {
            ServerLevel sv;
            double dz;
            double dy;
            double dx;
            ShadeSwordAltarBlockEntity altar = (ShadeSwordAltarBlockEntity)F;
            if (altar.tickCount % 20 == 0 && altar.getCharges() >= altar.getMaxCharges() - altar.getBloodCharges()) {
                double dx2 = (new Random().nextDouble() - 0.5) * 0.5;
                double dy2 = (new Random().nextDouble() - 0.5) * 0.5;
                double dz2 = (new Random().nextDouble() - 0.5) * 0.5;
                if (level instanceof ServerLevel) {
                    ServerLevel sv2 = (ServerLevel)level;
                    sv2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.getBlockPos().getX() + 0.5, (double)altar.getBlockPos().getY() + 0.25 * Math.random(), (double)altar.getBlockPos().getZ() + 0.5, 1, dx2, dy2, dz2, 0.1);
                }
            }
            if (altar.shouldSpawnParticleExplosion && altar.getCharges() == 1) {
                for (int i = 0; i < 10; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    if (!(level instanceof ServerLevel)) continue;
                    sv = (ServerLevel)level;
                    sv.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.getBlockPos().getX() + 0.5, (double)altar.getBlockPos().getY() + 0.25 * Math.random(), (double)altar.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.15);
                    if (i % 3 != 0) continue;
                    sv.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), (double)altar.getBlockPos().getX() + 0.5, (double)altar.getBlockPos().getY() + 0.25 * Math.random(), (double)altar.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.35);
                }
                altar.shouldSpawnParticleExplosion = false;
            }
            if (altar.shouldSpawnParticleExplosion && altar.getCharges() == altar.getMaxCharges() - altar.getBloodCharges()) {
                for (int i = 0; i < 20; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.6;
                    dy = (new Random().nextDouble() - 0.5) * 0.6;
                    dz = (new Random().nextDouble() - 0.5) * 0.6;
                    if (!(level instanceof ServerLevel)) continue;
                    sv = (ServerLevel)level;
                    sv.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.getBlockPos().getX() + 0.5, (double)altar.getBlockPos().getY() + 0.35 * Math.random(), (double)altar.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.15);
                    if (i % 3 != 0) continue;
                    sv.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), (double)altar.getBlockPos().getX() + 0.5, (double)altar.getBlockPos().getY() + 0.35 * Math.random(), (double)altar.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.35);
                }
                altar.shouldSpawnParticleExplosion = false;
            }
            if (altar.getCharges() > 0 && altar.tickCount % 2 == 0 && (double)level.random.nextFloat() < 0.01 * (double)altar.getCharges() && altar.level != null && altar.level.isClientSide) {
                Companions.PROXY.spawnShadeAltarParticles(altar, level, 0.0f, 0.0f, 0.0f, 5.0);
            }
            ++altar.tickCount;
        }
    }

    @Override
    protected boolean hasIncreasedFromPrevInteraction() {
        boolean ret = super.hasIncreasedFromPrevInteraction();
        if (ret) {
            this.shouldSpawnParticleExplosion = true;
        }
        return ret;
    }

    @Override
    public ShadeEntity spawnShade(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand, ShadowBellItem shadowBell) {
        ShadeEntity entity = (ShadeEntity)CompanionsEntities.SHADE_SWORD.get().create(pLevel);
        if (entity != null) {
            entity.tame(pPlayer);
            double r1 = 2.0;
            double r2 = 3.0;
            double u = pLevel.random.nextDouble();
            double r = Math.sqrt(u * (r2 * r2 - r1 * r1) + r1 * r1);
            float randYaw = pPlayer.getYRot() + (pLevel.random.nextFloat() * 2.0f - 1.0f) * 30.0f;
            float randPitch = pPlayer.getXRot() + (pLevel.random.nextFloat() * 2.0f - 1.0f) * 20.0f;
            Vec3 target = pPlayer.getEyePosition(1.0f).add(Vec3.directionFromRotation((float)randPitch, (float)randYaw).scale(r));
            int blockX = Mth.floor((double)target.x);
            int blockZ = Mth.floor((double)target.z);
            double px = (double)blockX + 0.5;
            double py = this.findPlaceToSpawn(pPlayer, pLevel, blockX, blockZ);
            double pz = (double)blockZ + 0.5;
            entity.moveTo(px, py, pz);
            for (int i = 0; i < 20; ++i) {
                double vx = (pLevel.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
                double vy = (pLevel.random.nextDouble() - 0.5) * (double)entity.getBbHeight();
                double vz = (pLevel.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
                if (!(pLevel instanceof ServerLevel)) continue;
                ServerLevel svlvl = (ServerLevel)pLevel;
                svlvl.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), px, py, pz, 1, vx, vy, vz, 0.15);
                if (i % 3 != 0) continue;
                svlvl.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), px, py, pz, 1, vx, vy, vz, 0.35);
            }
            if (this.isBloodUpgradeActive()) {
                AttributeInstance dmg;
                entity.setIsBlood(true);
                AttributeInstance maxHealth = entity.getAttribute(Attributes.MAX_HEALTH);
                if (maxHealth != null) {
                    float updatedHealth = (float)(maxHealth.getBaseValue() * CompanionsConfig.SHADOW_SWORD_BLOOD_MULTIPLIER);
                    maxHealth.setBaseValue((double)updatedHealth);
                    entity.setHealth(updatedHealth);
                }
                if ((dmg = entity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                    dmg.setBaseValue(dmg.getBaseValue() * CompanionsConfig.SHADOW_SWORD_BLOOD_MULTIPLIER);
                }
            }
            if (pPlayer.getItemInHand(pUsedHand).has(DataComponents.CUSTOM_NAME)) {
                entity.setHasReskin(true);
            }
            double dx = pPlayer.getX() - px;
            double dy = pPlayer.getY() + (double)pPlayer.getEyeHeight() - (py + (double)entity.getEyeHeight());
            double dz = pPlayer.getZ() - pz;
            float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            entity.setYRot(yaw);
            entity.yBodyRot = yaw;
            entity.yBodyRotO = yaw;
            entity.yHeadRot = yaw;
            entity.yHeadRotO = yaw;
            entity.setXRot(pitch);
            entity.xRotO = pitch;
            entity.setInvisible(true);
            pLevel.addFreshEntity((Entity)entity);
            this.activeShadeUUID = entity.getUUID();
            return entity;
        }
        return null;
    }
}

