/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.item.blockitem.CoinItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CorneliusContainerMenu
extends AbstractContainerMenu {
    private final CorneliusEntity cornelius;
    private final Container entityInventory;
    private boolean gameActive = false;
    public static final int BUTTON_START_GAME = 0;
    public static final int BUTTON_STOP_GAME = 1;
    public static final int ACTION_LOSE = 2;
    public static final int ACTION_TIE = 3;
    public static final int ACTION_WIN = 4;
    public static final int ACTION_JACK = 5;
    private static final List<Object> ALLOWED_BET_KEYS = new ArrayList<Object>();
    private static String cachedBets = null;

    public CorneliusContainerMenu(int windowId, Inventory playerInv, CorneliusEntity cornelius) {
        super(CompanionsMenuTypes.CORNELIUS_CONTAINER.get(), windowId);
        int col;
        this.cornelius = cornelius;
        this.entityInventory = cornelius.inventory;
        CorneliusContainerMenu.checkContainerSize((Container)this.entityInventory, (int)2);
        this.entityInventory.startOpen(playerInv.player);
        this.addSlot(new MainCoinSlot(this.entityInventory, 0, 8, 118));
        this.addSlot(new MainCoinSlot(this.entityInventory, 1, 26, 118));
        this.addSlot(new MainCoinSlot(this.entityInventory, 2, 44, 118));
        this.addSlot(new CrupierCoinSlot(this.entityInventory, 3, 62, 7));
        this.addSlot(new CrupierCoinSlot(this.entityInventory, 4, 80, 7));
        this.addSlot(new CrupierCoinSlot(this.entityInventory, 5, 98, 7));
        this.addDataSlot(new DataSlot(){

            public int get() {
                return CorneliusContainerMenu.this.gameActive ? 1 : 0;
            }

            public void set(int value) {
                CorneliusContainerMenu.this.gameActive = value != 0;
            }
        });
        int PLAYER_INVENTORY_START_Y = 144;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 144 + row * 18));
            }
        }
        int HOTBAR_START_Y = 202;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 202));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.entityInventory.stillValid(player) && this.cornelius.isAlive() && this.cornelius.distanceTo((Entity)player) < 8.0f;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.entityInventory.stopOpen(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            int containerSize = this.entityInventory.getContainerSize();
            if (index < containerSize ? !this.moveItemStackTo(stackInSlot, containerSize, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, containerSize, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean clickMenuButton(@NotNull Player player, int buttonId) {
        if (buttonId == 0) {
            this.gameActive = true;
            this.broadcastChanges();
            return true;
        }
        if (buttonId == 1) {
            this.gameActive = false;
            this.broadcastChanges();
            return true;
        }
        if (buttonId >= 2 && buttonId <= 5) {
            this.pay(switch (buttonId) {
                case 5 -> 2.5;
                case 4 -> 2.0;
                case 3 -> 1.0;
                default -> 0.0;
            }, player);
            this.gameActive = false;
            this.broadcastChanges();
            return true;
        }
        return super.clickMenuButton(player, buttonId);
    }

    private void pay(double multiplier, Player player) {
        for (int i = 3; i <= 5; ++i) {
            ItemStack bet = this.entityInventory.getItem(i);
            if (bet.isEmpty()) continue;
            int payoutTotal = (int)Math.floor((double)bet.getCount() * multiplier);
            int toSlot = Math.min(payoutTotal, bet.getMaxStackSize());
            int overflow = payoutTotal - toSlot;
            this.entityInventory.setItem(i, new ItemStack((ItemLike)bet.getItem(), toSlot));
            if (overflow <= 0) continue;
            ItemEntity drop = new ItemEntity(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), new ItemStack((ItemLike)bet.getItem(), overflow));
            player.level().addFreshEntity((Entity)drop);
        }
        this.entityInventory.setChanged();
    }

    private static boolean isAllowedBet(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        CorneliusContainerMenu.parsePossibleBets();
        for (Object object : ALLOWED_BET_KEYS) {
            TagKey anyTag;
            Item item;
            if (!(object instanceof Item ? stack.is(item = (Item)object) : object instanceof TagKey && stack.is(anyTag = (TagKey)object))) continue;
            return true;
        }
        return false;
    }

    private static void parsePossibleBets() {
        String[] parts;
        String raw = CompanionsConfig.CORNELIUS_JACKBLACK_BETS;
        if (raw == null) {
            raw = "";
        }
        if (raw.equals(cachedBets)) {
            return;
        }
        ALLOWED_BET_KEYS.clear();
        cachedBets = raw;
        for (String part : parts = raw.split(";")) {
            boolean isTag;
            ResourceLocation resourceLocation;
            String string = part.trim();
            if (string.isEmpty() || (resourceLocation = ResourceLocation.tryParse((String)((isTag = string.startsWith("#")) ? string.substring(1).trim() : string))) == null) continue;
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
                ALLOWED_BET_KEYS.add(tag);
                continue;
            }
            BuiltInRegistries.ITEM.getOptional(resourceLocation).ifPresent(ALLOWED_BET_KEYS::add);
        }
    }

    public static class MainCoinSlot
    extends Slot {
        public MainCoinSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return stack.getItem() instanceof CoinItem;
        }
    }

    public class CrupierCoinSlot
    extends Slot {
        public CrupierCoinSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return CorneliusContainerMenu.isAllowedBet(stack) && !CorneliusContainerMenu.this.gameActive;
        }

        public boolean mayPickup(@NotNull Player player) {
            return !CorneliusContainerMenu.this.gameActive;
        }

        public boolean allowModification(@NotNull Player pPlayer) {
            return !CorneliusContainerMenu.this.gameActive && super.allowModification(pPlayer);
        }
    }
}

