/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import dev.xylonity.companions.registry.CompanionsRecipes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class SoulFurnaceContainerMenu
extends AbstractContainerMenu {
    private final Container furnaceInventory;
    private final ContainerData data;
    private final Player player;

    public SoulFurnaceContainerMenu(int id, Inventory playerInventory, Container furnaceInventory, ContainerData data) {
        super(CompanionsMenuTypes.SOUL_FURNACE.get(), id);
        this.furnaceInventory = furnaceInventory;
        this.data = data;
        this.player = playerInventory.player;
        this.addSlot(new Slot(furnaceInventory, 0, 56, 22){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return SoulFurnaceContainerMenu.this.isValidInput(stack);
            }
        });
        this.addSlot(new Slot(this, furnaceInventory, 1, 116, 40){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        });
        int startX = 8;
        int startY = 97;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, startX + col * 18, startY + 58));
        }
        this.addDataSlots(data);
    }

    private boolean isValidInput(ItemStack stack) {
        if (this.player == null) {
            return false;
        }
        for (RecipeHolder rec : this.player.level().getRecipeManager().getAllRecipesFor(CompanionsRecipes.SOUL_FURNACE_TYPE.get())) {
            SoulFurnaceRecipe r;
            Recipe recipe = rec.value();
            if (!(recipe instanceof SoulFurnaceRecipe) || !(r = (SoulFurnaceRecipe)recipe).input().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.furnaceInventory.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            int containerSlotCount = 2;
            if (index < containerSlotCount ? !this.moveItemStackTo(stackInSlot, containerSlotCount, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, containerSlotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public int getCharge() {
        return this.data.get(0);
    }

    public int getProgress() {
        return this.data.get(1);
    }

    public int getProcessingTime() {
        return this.data.get(2);
    }
}

